# Zope imports
import zLOG
from zExceptions import BadRequest
from formencode import validators
import forms


class PhotoUpload(object):
    """ Generic photo tool class.
        Defines methods for photos management.
    """
    
    def __init__(self, gallery, album_id, album_title, context):
        self.context = context
        self.gallery = self.context.unrestrictedTraverse(gallery)
        self.album_id = album_id
        self.album_title = album_title
        self.errors = None

    def get_album(self):
        return self.gallery._getOb(self.album_id, None)
    
    def delete_album(self):
        if self.get_album():
            try:
                self.gallery.manage_delObjects([self.album_id])
            except BadRequest:
                zLOG.LOG(__name__, zLOG.WARNING, 'PhotoUpload::delete_album An error occurred while deleting photo album. Album can\'t be found.')

    def rename_album(self, id):
        if self.get_album():
            self.gallery.manage_renameObjects([self.album_id], [id])
            album = self.gallery._getOb(id, None)
            album.saveProperties(title=id)

    def get_or_create_album(self):
        if not self.get_album():
            title = self.album_title or self.album_id
            self.album_id = self.gallery.addNyPhotoFolder(id=self.album_id, title=title)
        return self.get_album()
    
    def get_photos(self):
        album = self.get_album()
        if album:
            return album.objectValues()

    def get_photo(self, id):
        album = self.get_album()
        if album:
            return album._getOb(id, None)

    def delete_photo(self, id):
        album = self.get_album()
        if album:
            try:
                album.manage_delObjects([id])
            except BadRequest:
                zLOG.LOG(__name__, zLOG.WARNING, 'PhotoUpload::delete_photo An error occurred while deleting photo. Photo can\'t be found.')

    def add_photo(self, title, file, **kwargs):
        try:
            form = forms.PhotoUploadForm.to_python(value={'title':title, 'file':file})
        except validators.Invalid, e:
            self.errors = e
        else:
            album = self.get_or_create_album()
            if not title:
                title = file.filename
            return album.addNyPhoto(id=file.filename, title=title, file=file, **kwargs)

    def update_photo(self, id_photo, title, file, **kwargs):
        photo = self.get_photo(id_photo)
        if photo:
            photo.saveProperties(title=title, file=file, **kwargs)
            return id_photo
        else:
            return self.add_photo(title, file, **kwargs)