# WatSan Platform - Rapid development of national water and sanitation internet portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web
# Cristian Romanescu, Eau De Web

#Python imports
from StringIO import StringIO
from unittest import TestSuite, makeSuite
from ws.common.sql import pg_drop_database
from Products.WSPortal.WSPortal import manage_addWSPortal
import os, ConfigParser

#Zope imports
from Testing import ZopeTestCase
from Testing.ZopeTestCase import FunctionalTestCase
from AccessControl.SecurityManagement import newSecurityManager, noSecurityManager
from zope.configuration.xmlconfig import xmlconfig
import transaction

#Product imports
from Products.Five.testbrowser import Browser

from Products.WSWebsite.constants import WEBSITE_ID
from Products.WSWebsite.WSWebsite import manage_addWSWebsite

test_zcml = """<configure
    xmlns="http://namespaces.zope.org/zope"
    xmlns:meta="http://namespaces.zope.org/meta"
    xmlns:five="http://namespaces.zope.org/five">

  <!-- this comes from Five/skel/site.zcml -->

  <include package="Products.Five"/>
  <include files="%(INSTANCE_HOME)s/etc/package-includes/*-meta.zcml" />
  <include files="%(INSTANCE_HOME)s/etc/package-includes/*-configure.zcml" />
  <meta:redefinePermission from="zope2.Public" to="zope.Public" />

  <five:loadProducts/>
  <five:loadProductsOverrides/>

</configure>
""" % {'INSTANCE_HOME': INSTANCE_HOME}

xmlconfig(StringIO(test_zcml), testing=True)


ZopeTestCase.installProduct('Localizer')
ZopeTestCase.installProduct('TextIndexNG3')
ZopeTestCase.installProduct('NaayaCore')
ZopeTestCase.installProduct('NaayaContent')
ZopeTestCase.installProduct('NaayaBase')
ZopeTestCase.installProduct('naayaHotfix')
ZopeTestCase.installProduct('Naaya')
ZopeTestCase.installProduct('PythonScripts')
ZopeTestCase.installProduct('ZMIntrospection')
ZopeTestCase.installProduct('WSWebsite')
ZopeTestCase.installProduct('WSPortal')

class WatsanTestCase(FunctionalTestCase):

    def _setup(self):
        # Read configuration from test.cfg located in instance
        path = os.path.join(CLIENT_HOME, 'test.cfg')
        if not os.path.exists(path):
            raise Exception('Cannot read test configuration from tests/test.cfg')

        self.cfg = ConfigParser.ConfigParser()
        self.cfg.read(path)

        self.susername = self.cfg.get('ws.common.sql', 'susername')
        self.spassword = self.cfg.get('ws.common.sql', 'spassword')
        self.database = self.cfg.get('ws.common.sql', 'database')
        self.host = self.cfg.get('ws.common.sql', 'host')
        self.owner = self.cfg.get('ws.common.sql', 'owner')
        self.owner_pass = self.cfg.get('ws.common.sql', 'owner_pass')
        self.default_db = self.cfg.get('ws.common.sql', 'default_db')
        self.ws_common_tempdb = self.cfg.get('ws.common.sql', 'ws_common_tempdb')


        self.app = ZopeTestCase.app()
        ZopeTestCase.utils.setupCoreSessions(self.app)
        self.app.acl_users._doAddUser('watsan', 'watsan', ['Manager'], [])
        self.login('watsan')

        # add test portal
        COUNTRY_CODE = 'test'
        PORTAL_ID = 'country_portal_' + COUNTRY_CODE
        if not hasattr(self.app, PORTAL_ID):
            manage_addWSPortal(self.app, COUNTRY_CODE, 2, 'en', 'skin_test', 'post', 'http://mapserver', 'no_gmap_key')

        # add website
        manage_addWSWebsite(self.app, db_host='localhost',
                db_username=self.susername, db_password=self.spassword, db_name=self.database)


        self.website = getattr(self.app, WEBSITE_ID)
        self.portal = getattr(self.app, PORTAL_ID)
        self.logout()
        transaction.commit()

        self.browser = Browser()
        self.browser.handleErrors = False


    def _clear(self, *args):
        if self.app.hasObject(WEBSITE_ID):
            self.app.manage_delObjects([WEBSITE_ID])
        if self.app.acl_users.getUser('watsan') is not None:
            self.app.acl_users._doDelUsers(['watsan'])
        transaction.commit()

        if hasattr(self, 'website'):
            del self.website
        if hasattr(self, 'browser'):
            del self.browser

        #pg_drop_database(self.susername, self.spassword, self.host, 
        #                 self.database, self.default_db, None)
        # Cannot drop due to SQLAlchemy session pool leaving open connections

        super(WatsanTestCase, self)._clear(*args)

    def login(self, userid):
        aclu = self.app.acl_users
        user = aclu.getUserById(userid).__of__(aclu)
        self.app.REQUEST.AUTHENTICATED_USER = user
        newSecurityManager(None, user)

    def logout(self):
        self.app.REQUEST.AUTHENTICATED_USER = None
        noSecurityManager()
