'''
Created on Apr 21, 2010

@author: cristiroma
'''
from sqlalchemy.sql.expression import and_, or_

from ws.common.sql.mappings.Waterpoint import Waterpoint
from ws.common.sql.mappings.SanitationFacility import Sanitation
from ws.common.sql.mappings.PWS import PWS
from ws.common.sql.mappings.Lexicon  import UpisFunctionality, WaterPointType,\
    InfrastructureLocationType, PWSFunctionality
from ws.common.sql.mappings.Upis import Upis

class FacilitiesAccessStatistics(object):
    
    def __init__(self, session):
        self.session = session
        self.wp = {
            'public_taps' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'hand_pumps' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'modern_wells' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'other' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'total' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            }
        }
        self.sf = {
            'public_toilets_educational' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'public_toilets_health' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'public_toilets_other' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            },
            'public_toilets_total' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            }
        }

        self.pws = {
            'water_schemes' : {
                'functional' : -1,
                'out_of_service' : -1,
                'total' : -1
            }
        }

        self._compute_water_points()
        self._compute_sanitation_facilities()
        self._compute_pws()


    def pws_query(self):
        return self.session.query(PWS).filter(and_(PWS.upiscode == Upis.upiscode, Upis.approved == True))


    def _compute_pws(self):
        self.pws['water_schemes']['functional'] = self.session.query(PWS).filter(PWS.uppwsfunc == PWSFunctionality.IN_SERVICE).count()
        self.pws['water_schemes']['out_of_service'] = self.session.query(PWS).filter(PWS.uppwsfunc == PWSFunctionality.OUT_OF_ORDER).count()
        self.pws['water_schemes']['not_used'] = self.session.query(PWS).filter(PWS.uppwsfunc == PWSFunctionality.NOT_USED).count()
        self.pws['water_schemes']['unknown'] = self.session.query(PWS).filter(PWS.uppwsfunc == PWSFunctionality.UNKNOWN).count()
        self.pws['water_schemes']['total'] = self.session.query(PWS).count()


    def sf_query(self):
        return self.session.query(Sanitation).filter(and_(Sanitation.upiscode == Upis.upiscode, Upis.approved == True))


    def _compute_sanitation_facilities(self):
        """ Compute the statistics for sanitation facilities area of the page """
        self.sf['public_toilets_educational']['functional'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.EDUCATIONAL_INFRASTRUCTURE, 
                     Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.sf['public_toilets_educational']['out_of_service'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.EDUCATIONAL_INFRASTRUCTURE, 
                     Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()
        self.sf['public_toilets_educational']['total'] = \
            self.sf_query().filter(Upis.upisloctype == InfrastructureLocationType.EDUCATIONAL_INFRASTRUCTURE).count()

        self.sf['public_toilets_health']['functional'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.HEALTH_INFRASTRUCTURE, 
                     Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.sf['public_toilets_health']['out_of_service'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.HEALTH_INFRASTRUCTURE, 
                     Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()
        self.sf['public_toilets_health']['total'] = \
            self.sf_query().filter(Upis.upisloctype == InfrastructureLocationType.HEALTH_INFRASTRUCTURE).count()

        self.sf['public_toilets_other']['functional'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.OTHER, 
                     Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.sf['public_toilets_other']['out_of_service'] = \
            self.sf_query().filter(
                and_(Upis.upisloctype == InfrastructureLocationType.OTHER, 
                     Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()
        self.sf['public_toilets_other']['total'] = \
            self.sf_query().filter(Upis.upisloctype == InfrastructureLocationType.OTHER).count()

        self.sf['public_toilets_total']['functional'] = \
            self.sf_query().filter(Upis.upisobj == UpisFunctionality.IN_SERVICE).count()
        self.sf['public_toilets_total']['out_of_service'] = \
            self.sf_query().filter(Upis.upisobj == UpisFunctionality.OUT_OF_ORDER).count()
        self.sf['public_toilets_total']['total'] = self.sf_query().count()


    def wp_query(self):
        return self.session.query(Waterpoint).filter(and_(Waterpoint.upiscode == Upis.upiscode, Upis.approved == True))

    def _compute_water_points(self):
        """ Compute the statistics for water points area of the page """
        self.wp['public_taps']['functional'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.PUBLIC_TAP,Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.wp['public_taps']['out_of_service'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.PUBLIC_TAP, Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()

        self.wp['public_taps']['total'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.PUBLIC_TAP)
            ).count()

        self.wp['hand_pumps']['functional'] = \
            self.wp_query().filter(
                and_(
                     or_(
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_BOREHOLE,
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_MODERN_WELL
                        ), 
                    Upis.upisobj == UpisFunctionality.IN_SERVICE
                )
            ).count()
        self.wp['hand_pumps']['out_of_service'] = \
            self.wp_query().filter(
                and_(or_(
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_BOREHOLE,
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_MODERN_WELL
                         ), 
                     Upis.upisobj == UpisFunctionality.OUT_OF_ORDER
                )
            ).count()
        self.wp['hand_pumps']['total'] = \
            self.wp_query().filter(
                and_(
                     or_(
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_BOREHOLE,
                         Waterpoint.upwptype == WaterPointType.HANDPUMP_ON_MODERN_WELL)
                )
            ).count()

        self.wp['modern_wells']['functional'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.MODERN_WELL, Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.wp['modern_wells']['out_of_service'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.MODERN_WELL, Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()
        self.wp['modern_wells']['total'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.MODERN_WELL)
        ).count()

        self.wp['other']['functional'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.OTHER, Upis.upisobj == UpisFunctionality.IN_SERVICE)
            ).count()
        self.wp['other']['out_of_service'] = \
            self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.OTHER, Upis.upisobj == UpisFunctionality.OUT_OF_ORDER)
            ).count()
        self.wp['other']['total'] = self.wp_query().filter(
                and_(Waterpoint.upwptype == WaterPointType.OTHER)
        ).count()

        self.wp['total']['functional'] = \
            self.wp_query().filter(Upis.upisobj == UpisFunctionality.IN_SERVICE).count()
        self.wp['total']['out_of_service'] = \
            self.wp_query().filter(Upis.upisobj == UpisFunctionality.OUT_OF_ORDER).count()
        self.wp['total']['total'] = self.wp_query().count()
