# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web

# Contributor(s):
# Cristian Romanescu, Eau De Web
from ws.common.sql.mappings.Waterpoint import Waterpoint
from ws.common.sql.mappings.SanitationFacility import Sanitation
from ws.common.sql.mappings.Upis import Upis

def insert_lexicon_row(session, cl, code, name, name2):
    new_inst = cl(code, name, name2)
    session.add(new_inst)


def update_lexicon_row(session, cl, code, name, name2):
    inst = session.query(cl).filter(cl.code == code).one()
    inst.name = name
    inst.name2 = name2
    session.add(inst)


def delete_waterpoint(session, id):
    wp = session.query(Waterpoint).filter_by(upiscode = id).one()
    upis = session.query(Upis).filter_by(upiscode = id).one()
    session.delete(wp)
    session.flush()
    session.delete(upis)


def delete_sanitation_facility(session, id):
    wp = session.query(Sanitation).filter_by(upiscode = id).one()
    upis = session.query(Upis).filter_by(upiscode = id).one()
    session.delete(wp)
    session.flush()
    session.delete(upis)


def approve_facility(session, id, upisx=None, upisy=None):
    ob = session.query(Upis).filter_by(upiscode = id).one()
    ob.approved = True
    if upisx:
        ob.upisx = upisx
    if upisy:
        ob.upisy = upisy
    session.add(ob)
    session.flush()
    # Update the geography column to appear on generated maps
    session.connection().execute("UPDATE t_upis SET upiscoordinate=ST_SetSRID(ST_MakePoint(upisx, upisy),4326) WHERE upiscode='%s'" % id)
    session.flush()


