# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
#
# Tests for this package

from unittest import TestSuite, makeSuite

from ws.common.exceptions import DatabaseException
from ws.common.sql import pg_create_database, pg_drop_database, pg_connect, execute_sql
from ws.common.tests import WatsanTestCase



class SQLTests(WatsanTestCase):


    def afterSetUp(self):
        super(SQLTests, self).afterSetUp()
        pg_create_database(self.susername, self.spassword, 
                           self.host, self.ws_common_tempdb, self.owner, 
                           self.default_db)


    def beforeTearDown(self):
        pg_drop_database(self.susername, self.spassword, self.host, 
                         self.ws_common_tempdb, self.default_db, None)


    def test_pg_connect(self):
        conn = pg_connect(self.susername, self.spassword, self.host, self.ws_common_tempdb)
        self.assertNotEqual(None, conn)
        self.assertFalse(conn.closed)
        conn.close()


    def test_pg_create_database(self):
        # Raise DatabaseException error if no sufficient privilege
        self.assertRaises(DatabaseException, pg_create_database, 
                          self.owner, self.owner_pass, self.host, 
                          self.ws_common_tempdb, self.owner, self.default_db, None)

        # Raise DatabaseException error if database already exists
        self.assertRaises(DatabaseException, pg_create_database, 
                          self.susername, self.spassword, self.host, 
                          self.ws_common_tempdb, self.owner, self.default_db, None)


    def test_pg_drop_database(self):
        # Drop database
        pg_drop_database(self.susername, self.spassword, self.host, 
                         self.ws_common_tempdb, self.default_db, None)
        pg_create_database(self.susername, self.spassword, self.host, 
                           self.ws_common_tempdb, self.owner, self.default_db, None)


    def test_execute_sql(self):
        conn = pg_connect(self.susername, self.spassword, self.host, self.ws_common_tempdb)
        cur = conn.cursor()
        sql = ["CREATE TABLE test (COL1 VARCHAR);", "INSERT INTO test VALUES ('this is a test');"]
        self.assertTrue(execute_sql(cur, sql, None))
        cur.close()
        conn.commit()
        conn.close()
        del conn

        conn = pg_connect(self.susername, self.spassword, self.host, self.ws_common_tempdb)
        cur = conn.cursor()
        cur.execute('SELECT COL1 FROM test')
        rows = cur.fetchall()
        self.assertEqual(rows[0][0], 'this is a test')
        cur.close()
        conn.close()



def test_suite():
    """
    Test suite for the watsan.common package
    """
    suite = TestSuite()
    suite.addTest(makeSuite(SQLTests))
    return suite

