# coding=UTF-8
'''
Created on Feb 12, 2010

@author: cristiroma
'''

from unittest import TestSuite, makeSuite
from ws.common.sql import pg_drop_database, pg_create_database
from ws.common.tests import WatsanTestCase
from ws.common.sql.query import get_subdivision_list, get_lexicons
from ws.common.exceptions import ValidationException



class QueryTests(WatsanTestCase):


    def afterSetUp(self):
        super(QueryTests, self).afterSetUp()
        pg_create_database(self.susername, self.spassword, 
                           self.host, self.ws_common_tempdb, self.owner, 
                           self.default_db)


    def beforeTearDown(self):
        pg_drop_database(self.susername, self.spassword, self.host, 
                         self.ws_common_tempdb, self.default_db, None)


    def test_get_subdivision_list(self):
        session = self.portal.get_db_session()

        # Validation
        self.assertRaises(ValidationException, get_subdivision_list, session, 1, 'non-null')
        self.assertRaises(ValidationException, get_subdivision_list, session, 2, None)
        self.assertRaises(ValidationException, get_subdivision_list, session, 6, 'non-null')
        self.assertRaises(ValidationException, get_subdivision_list, session, 0, 'non-null')

        # Data
        ret = get_subdivision_list(session, 1)
        self.assertEqual(12, len(ret))

        ret = get_subdivision_list(session, 2, 'SN-DB')
        self.assertEqual(3, len(ret))

    def test_get_lexicons(self):
        d = get_lexicons()
        self.assertTrue(len(d.keys()) > 60)

        cl = d[d.keys()[0]]

        session = self.website.get_db_session()
        values = session.query(cl).all()
        self.assertTrue(len(values) > 0)

        session = self.portal.get_db_session()
        values = session.query(cl).all()
        self.assertTrue(len(values) > 0)



def test_suite():
    """
    Test suite for the watsan.common package
    """
    suite = TestSuite()
    suite.addTest(makeSuite(QueryTests))
    return suite

