from sqlalchemy.sql.expression import or_
from sqlalchemy.sql import desc, asc

from ws.common.sql.mappings.WaterQuality import WaterQuality, WaterQualityData

def filter_water_reports(session, sort_on, sort_order):
    """
    Filters the list of water quality reports from WaterQuality
    """
    query = session.query(WaterQuality)
    #if conformity:
    #    query = query.filter(WaterQuality.wqmconformity==conformity)
    if sort_on:
        column = getattr(WaterQuality, sort_on)
        if sort_order:
            query = query.order_by(asc(column))
        else:
            query = query.order_by(desc(column))
    return query

def get_wqm_data(session, id):
    """
    Returns water quality measurements attached to a given report id
    """
    return session.query(WaterQualityData).filter(WaterQualityData.wqmdatreportcode == id).all()

def get_wqm(session, id):
    """
    Returns a water quality report for a given id
    """
    return session.query(WaterQuality).filter(WaterQuality.wqmcode == id).one()