'''
Created on May 4, 2010

@author: cristiroma
@TODO: REMOVE NO LONGER USED
'''
from sqlalchemy.sql.expression import asc, desc
from ws.common.utilities.paginate import DiggPaginator, EmptyPage, InvalidPage


def get_catalog_item(session, klass, code):
    """
    Retrieve one item from the catalog.
    """
    return session.query(klass).filter_by(code=code).one()


def get_catalog_items(session, REQUEST, klass, filter=[]):
    """
    Retrieve all items from the catalog, paginated.
    """
    sort = REQUEST.get('sort', '')
    order = REQUEST.get('order', False)
    query = session.query(klass)
    if filter:
        for column in filter:
            if REQUEST.get(column, None):
                print REQUEST.get(column)
                query = query.filter(getattr(klass, column)==REQUEST.get(column))
    if sort:
        if order:
            query = query.order_by(asc(sort))
        else:
            query = query.order_by(desc(sort))

    paginator = DiggPaginator(query, 20, body=5, padding=2, orphans=5)   #Show 20 documents per page

    # Make sure page request is an int. If not, deliver first page.
    try:
        page = int(REQUEST.get('page', '1'))
    except ValueError:
        page = 1

    # If page request (9999) is out of range, deliver last page of results.
    try:
        items = paginator.page(page)
    except (EmptyPage, InvalidPage):
        items = paginator.page(paginator.num_pages)

    return items


def get_brands_in_use(session, klass):
    """ """
    brands = session.query(klass.brand).distinct().order_by(klass.brand)
    return [brand[0] for brand in brands]


def get_catalog_items_in_use(session, cat_klass, attr):
    """ """
    cools = session.query(attr).distinct().order_by(attr)
    return session.query(cat_klass).filter(cat_klass.code.in_([cool[0] for cool in cools])).all()
