'''
Created on Apr 30, 2010

@author: cristiroma
'''
from ws.common.sql.mappings.Upis import Upis
from ws.common.sql.mappings.Waterpoint import Waterpoint
from sqlalchemy.sql.expression import and_, asc, update
from ws.common.sql.mappings.SanitationFacility import Sanitation
from ws.common.sql.mappings import Locality as mod_loc
from ws.common.sql.mappings.Subdivision import Subdivision, SubdivisionStats
from ws.common.utilities import dummy_insert
import time, math

class WatsanStatisticalData(object):

    def __init__(self, session):
        self.session = session


    def count_locality_statistics(self):
        return self.session.query(mod_loc.LocalityStats).count()


    def count_localities(self):
        return self.session.query(mod_loc.Locality).count()


    def count_subdivision_statistics(self):
        return self.session.query(SubdivisionStats).count()


    def count_subdivisions(self):
        return self.session.query(Subdivision).count()

    def valid_rank(self):
        subdiv = self.session.query(SubdivisionStats).filter('national_rank > 0').count()
        locs = self.session.query(mod_loc.LocalityStats).filter('national_rank > 0').count()
        return subdiv > 0 and locs > 0


    def wp_query(self, session, adlocode):
        return session.query(Waterpoint).filter(
            and_(
                    Waterpoint.upiscode == Upis.upiscode,
                    Upis.approved == True,
                    Upis.upisadlocode == adlocode
                )
        )


    def sf_query(self, session, adlocode):
        return session.query(Sanitation).filter(
            and_(
                    Sanitation.upiscode == Upis.upiscode,
                    Upis.approved == True,
                    Upis.upisadlocode == adlocode
                )
        )


    def compute_locality_statistics(self):
        """ Compute statistics for locality """
        print 'Computing statistics for localities'
        start = time.time()
        # TODO: Configure server accordingly
        # 2010-06-01 19:44:33 EEST LOG: checkpoints are occurring too frequently (13 seconds apart)
        # 2010-06-01 19:44:33 EEST HINT: Consider increasing the configuration parameter "checkpoint_segments".

        # Compute for all localities at once from a single update statement
        # Homogenize t_adloc_stat table and add one locality for each row from t_adloc
        self.session.connection().execute("INSERT INTO t_adloc_stat (adlocode) SELECT adlocode FROM t_adloc WHERE adlocode NOT IN (SELECT adlocode FROM t_adloc_stat)");
        self.session.flush()


        # population (LOC012) - Formula: LOC008 x (1 + LOC010) ^ (YEAR - LOC009)
        self.session.connection().execute("UPDATE t_adloc_stat AS B SET population = (SELECT CAST(A.adlopop * power(1 + A.adlopopgr, EXTRACT(year FROM current_date) - adlopopyear) AS integer) FROM t_adloc AS A where A.adlocode = B.adlocode)")
        self.session.flush()


        # adlopopupe (LOC013) - Formula: LOC012
        self.session.execute(update(mod_loc.table_adloc_stat, values={mod_loc.table_adloc_stat.c.adlopopupe : mod_loc.table_adloc_stat.c.population}))
        self.session.flush()


        # adlohhnbr (LOC014) - Formula: LOC013 / LOC011
        self.session.connection().execute("""UPDATE t_adloc_stat B SET adlohhnbr =
                            (SELECT CAST(B.adlopopupe / A.adlopophh AS integer)
                            FROM t_adloc A WHERE B.adlopopupe IS NOT NULL AND A.adlopophh IS NOT NULL AND B.adlocode = A.adlocode)""")
        self.session.flush()


        # wp_func_equiv (LOC024) - Formula: SELECT SUM(LWP003 * WP007.EWP) WHERE locality = 'xxxx'
        # select sum(A.upwpnok * B.ewp) from t_upwpn A INNER JOIN lex_wp007 B ON A.upwpntype = B.code AND wpnadlocode='02111013';
        self.session.connection().execute("""UPDATE t_adloc_stat C SET wp_func_equiv =
                            (SELECT sum(A.upwpnok * B.ewp) FROM t_upwpn A
                            INNER JOIN lex_wp007 B ON A.upwpntype = B.code AND A.wpnadlocode = C.adlocode)""")
        self.session.flush()


        # wp_nonfunc_equiv (LOC025)
        self.session.connection().execute("""UPDATE t_adloc_stat C SET wp_nonfunc_equiv =
                            (SELECT sum(A.upwpnoknot * B.ewp) FROM t_upwpn A
                            INNER JOIN lex_wp007 B ON A.upwpntype = B.code AND A.wpnadlocode = C.adlocode)""")
        self.session.flush()


        # pop_served_water (LOC017) - Formula: MIN(LOC013, wp_func_equiv(nb_EWP) * mnp_per_EWP)
        self.session.connection().execute("""UPDATE t_adloc_stat C SET pop_served_water =
                            (SELECT LEAST(A.adlopopupe, A.wp_func_equiv * B.numeric_value) FROM t_adloc_stat A, watsan_cfg B WHERE B.id='max_persons_ewp' AND A.adlocode = C.adlocode)""")
        self.session.flush()


        # water_access (LOC018) - Formula: [pop_served_water(LOC017) / lstats.adlopopupe(LOC013)]
        self.session.connection().execute("""UPDATE t_adloc_stat SET water_access = pop_served_water / CAST(adlopopupe as double precision) WHERE adlopopupe IS NOT NULL AND adlopopupe <> 0""")
        self.session.flush()


        # water_functionality_rate (LOC019)
        self.session.connection().execute("""UPDATE t_adloc_stat SET water_functionality_rate = CAST(wp_func_equiv as double precision) / (wp_func_equiv + wp_nonfunc_equiv) WHERE wp_func_equiv IS NOT NULL AND wp_nonfunc_equiv IS NOT NULL AND wp_func_equiv + wp_nonfunc_equiv <> 0""")
        self.session.flush()


        # water_points (LOC022) - Formula: SELECT SUM (LWP005) WHERE locality = 'xxxx' AND LWP002 IN ('01', '02', '03', '04', '05', '09','13')
        self.session.connection().execute("""UPDATE t_adloc_stat A SET water_points =
                (SELECT sum(upwpntot) FROM t_upwpn B WHERE A.adlocode = B.wpnadlocode
                AND upwpntype in  ('01', '02', '03', '04', '05', '09','13'))""")
        self.session.flush()


        # wp_inventoried (LOC023) - Formula: SELECT COUNT(*) FROM WP WHERE locality = 'xxxx' AND WP008 IN ('01', '03', '04', '05', '06')
        self.session.connection().execute("""UPDATE t_adloc_stat A SET wp_inventoried =
                (SELECT COUNT(*) FROM t_upis B WHERE upistype = 'WP'
                AND upisloctype IN ('01', '03', '04', '05', '06')
                AND B.upisadlocode = A.adlocode
                AND contributed = FALSE AND approved = TRUE)""")
        self.session.flush()


        # water_inventory_rate (LOC020) - Formula: wp_inventoried(LOC023) / water_points(LOC022)
        self.session.connection().execute("""UPDATE t_adloc_stat SET water_inventory_rate =
                CAST(wp_inventoried as double precision) / water_points WHERE wp_inventoried IS NOT NULL and water_points <> 0""")
        self.session.flush()


        # pop_served_sanitation (LOC026) - Formula: INT(sf_access(LOC027) * adlopopupe(LOC013))
        self.session.connection().execute("""UPDATE t_adloc_stat A SET pop_served_sanitation = (SELECT CAST(sf_access * adlopopupe AS integer) FROM t_adloc B WHERE A.adlocode = B.adlocode)""")
        self.session.flush()


        # sf_existing_inventoried (LOC033) - Formula: SELECT COUNT(*) FROM SF WHERE locality = "xxxx"
        self.session.connection().execute("""UPDATE t_adloc_stat A SET sf_existing_inventoried = (
                            SELECT COUNT(*) FROM t_upis B INNER JOIN t_upsf C ON C.upiscode = B.upiscode
                            WHERE B.upisadlocode = A.adlocode AND B.upistype = 'SF'
                            AND contributed = FALSE AND approved = TRUE)""")
        self.session.flush()


        # sf_functional (LOC034) - Formula SELECT COUNT(*) FROM SF WHERE locality='xxxx' AND SF050 = '01' AND SF006 IN ('09', '10', '11', '12', '13', '14')
        self.session.connection().execute("""UPDATE t_adloc_stat A SET sf_functional = (
                            SELECT COUNT(*) FROM t_upis B INNER JOIN t_upsf C ON C.upiscode = B.upiscode
                            WHERE C.upsffunc = '01'  AND B.upisadlocode = A.adlocode
                            AND C.upsftype IN ('09', '10', '11', '12', '13', '14') AND B.upistype = 'SF'
                            AND contributed = FALSE AND approved = TRUE)""")
        self.session.flush()


        # sf_nonfunctional (LOC035) - Formula SELECT COUNT(*) FROM SF WHERE locality='xxxx' AND SF050 <> '01' AND SF006 IN ('09', '10', '11', '12', '13', '14')
        self.session.connection().execute("""UPDATE t_adloc_stat A SET sf_functional = (
                            SELECT COUNT(*) FROM t_upis B INNER JOIN t_upsf C ON C.upiscode = B.upiscode
                            WHERE C.upsffunc <> '01' AND B.upisadlocode = A.adlocode
                            AND C.upsftype IN ('09', '10', '11', '12', '13', '14')
                            AND B.upistype = 'SF'
                            AND contributed = FALSE AND approved = TRUE)""")
        self.session.flush()


        # sf_existing_required (LOC032) - Formula: SUM(LSP005) WHERE (locality = 'XXXX' AND LSP002 IN ('09', '10', '11', '12', '13', '14'))
        self.session.connection().execute("""UPDATE t_adloc_stat A SET sf_existing_required =
                            (SELECT sum(upsfntot) FROM t_upsfn B WHERE A.adlocode = B.sfnadlocode
                            AND upsfntype in  ('09', '10', '11', '12', '13', '14'))""")
        self.session.flush()


        # sf_coverage_rate (LOC028) - Formula: sf_existing_required(LOC032) / locality.adlosfreq(LOC031)
        self.session.connection().execute("""UPDATE t_adloc_stat A SET sf_coverage_rate = (
                            SELECT CAST(A.sf_existing_required as double precision) / B.adlosfreq FROM t_adloc B
                            WHERE B.adlocode = A.adlocode AND B.adlosfreq <> 0)""")
        self.session.flush()


        # sf_func_rate (LOC029) - Formula: sf_functional(LOC034) / ( sf_functional(LOC034) + sf_nonfunctional(LOC035) )
        self.session.connection().execute("""UPDATE t_adloc_stat SET sf_func_rate = CAST(sf_functional as double precision) / sf_functional + sf_nonfunctional WHERE (sf_functional + sf_nonfunctional ) <> 0""")
        self.session.flush()


        # sf_inventory_rate (LOC030) - Formula: sf_existing_inventoried(LOC033) / sf_existing_required(LOC032)
        self.session.connection().execute("""UPDATE t_adloc_stat SET sf_inventory_rate = CAST(sf_existing_inventoried as double precision) / sf_existing_required WHERE sf_existing_required <> 0""")
        self.session.flush()

        dummy_insert(self.session)

        print 'Done processing all localities in %s seconds' % (time.time() - start)


    def compute_localities_national_rank(self):
        """
        National_rank (LOC021) - Formula: Order by the water_access (LOC018) and
        split the number of localities in 5 intervals
        """
        session = self.session
        session.flush()
        count = session.query(mod_loc.Locality).count()
        limit = math.ceil(count / 5)
        stats = session.query(mod_loc.LocalityStats).order_by(asc(mod_loc.LocalityStats.water_access))
        idx = 0
        for stat in stats:
            idx += 1
            rank = int(math.floor(idx / limit))
            if rank > 4:
                rank = 4
            stat.national_rank = rank
            session.merge(stat)



    def compute_subdivision_national_rank(self):
        """
        National_rank (SU5012) - Formula: Order by the water_access (SU5009) and
        split the number of subdivisions in 5 intervals
        """
        session = self.session
        session.flush()
        count = session.query(SubdivisionStats).count()
        limit = math.ceil(count / 5)
        stats = session.query(SubdivisionStats).order_by(asc(SubdivisionStats.water_access))
        idx = 0
        for stat in stats:
            idx += 1
            rank = int(math.floor(idx / limit))
            if rank > 4:
                rank = 4
            stat.national_rank = rank
            session.merge(stat)



    def compute_subdivision_statistics(self):
        print 'Computing statistics for subdivisions'
        start = time.time()

        self.session.connection().execute("INSERT INTO t_adreglev_stat (code) SELECT code FROM t_adreglev WHERE code NOT IN (SELECT code FROM t_adreglev_stat)");
        self.session.flush()

        for level in range(1, 6): # Levels 1 - 5
            # t_adreglev_stat.population (SU5005)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET localities =
                    (SELECT count(*) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.pop_estimated (SU5006)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET pop_estimated =
                    (SELECT SUM(B.adlopopupe) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.households_estimated (SU5007)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET households_estimated =
                    (SELECT SUM(B.adlohhnbr) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.pop_served_water (SU5008)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET pop_served_water =
                    (SELECT SUM(B.pop_served_water) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.water_points (SU5013)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET water_points =
                    (SELECT SUM(B.water_points) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.wp_inventoried (SU5014)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET wp_inventoried =
                    (SELECT SUM(B.wp_inventoried) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.wp_func_equiv (SU5015)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET wp_func_equiv =
                    (SELECT SUM(B.wp_func_equiv) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.wp_nonfunc_equiv (SU5016)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET wp_nonfunc_equiv =
                    (SELECT SUM(B.wp_nonfunc_equiv) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.pop_served_sanitation (SU5017)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET pop_served_sanitation =
                    (SELECT SUM(B.pop_served_sanitation) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.sf_required (SU5022)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET sf_required =
                    (SELECT SUM(B.adlosfreq) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.sf_existing_required (SU5023)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET sf_existing_required =
                    (SELECT SUM(B.sf_existing_required) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.sf_existing_inventoried (SU5024)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET sf_existing_inventoried =
                    (SELECT SUM(B.sf_existing_inventoried) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.sf_functional (SU5025)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET sf_functional =
                    (SELECT SUM(B.sf_functional) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.sf_nonfunctional (SU5026)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET sf_nonfunctional =
                    (SELECT SUM(B.sf_nonfunctional) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.school (SU5027)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET school =
                    (SELECT SUM(B.adloschool) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

            # t_adreglev_stat.health (SU5028)
            self.session.connection().execute("""UPDATE t_adreglev_stat A SET health =
                    (SELECT SUM(B.adlohealth) FROM view_subdivision_statistics B WHERE B.level%(level)s = A.code)
                    WHERE A.code IN (SELECT code FROM t_adreglev WHERE level = %(level)s);""" % {'level' : level})

        self.session.flush()

        # water_access (SU5009)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET water_access =
                    (CAST(pop_served_water as double precision) / pop_estimated) WHERE pop_estimated <> 0;""")
        self.session.flush()

        # water_inventory_rate (SU5011)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET water_inventory_rate =
                    (CAST(wp_inventoried as double precision) / water_points) WHERE water_points <> 0""")
        self.session.flush()

        # water_functionality_rate (SU5010)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET water_functionality_rate =
                    (CAST(wp_func_equiv as double precision) / ( CAST(wp_func_equiv as double precision) + wp_nonfunc_equiv ) )
                    WHERE (wp_func_equiv + wp_nonfunc_equiv) <> 0;""")
        self.session.flush()

        # sanitation_access (SU5018)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET sanitation_access =
                    (CAST(pop_served_sanitation as double precision) / CAST(pop_estimated as double precision) )
                    WHERE pop_estimated <> 0""")
        self.session.flush()

        # sf_func_rate (SU5020)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET sf_func_rate =
                    (CAST(sf_functional as double precision) / ( CAST(sf_functional as double precision) + sf_nonfunctional ) )
                    WHERE ( sf_functional + sf_nonfunctional ) <> 0""")
        self.session.flush()

        # sf_coverage_rate (SU5019)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET sf_coverage_rate =
                    (CAST(sf_required as double precision) / CAST(sf_existing_required as double precision) )
                    WHERE sf_existing_required <> 0""")
        self.session.flush()

        # sf_inventory_rate (SU5021)
        self.session.connection().execute("""UPDATE t_adreglev_stat SET sf_inventory_rate =
                    (CAST(sf_existing_inventoried as double precision) / CAST(sf_required as double precision) )
                    WHERE sf_required <> 0""")
        self.session.flush()


        dummy_insert(self.session)

        print 'Done processing all subdivisions in %s seconds' % (time.time() - start)
