'''
Created on Apr 29, 2010

@author: cristiroma
'''
# Search functionality
from ws.common.sql.mappings import Waterpoint as wp_models
from ws.common.sql.mappings import PWS as pws_models 
from ws.common.sql.mappings import SanitationFacility as sf_models
from ws.common.sql.mappings import Subdivision as sub_models
from ws.common.sql.mappings import Locality as loc_models
from ws.common.sql.mappings import Organisation as org_models
from ws.common.sql.mappings import Catalogs as cat_models
 
from sqlalchemy.sql.expression import or_

class SiteSearch(object):


    def __init__(self, session):
        self.session = session
        self.query = None
        self.filter_like = None

        self.localities = []
        self.subdivisions = []
        self.wp = []
        self.sf = []
        self.pws = []
        self.organisations = []


    def do_search(self, query, lookup=[]):
        """
        Do the actual search
        Parameters
            q
                String to freely search within database
            lookup
                An array with objects to search into. 
                Possible values: 'locality', 'subdivision', 'WP', 'SF'. 
                If empty looks in all objects
        """
        if query:
            self.query = query.strip()
        if not query or len(self.query) < 2:
            raise Exception('Search terms must be at least 2 characters long')

        self.filter_like = '%%%s%%' % (self.query)

        if not lookup or 'locality' in lookup:
            self.localities = self._q_localities()
        if not lookup or 'subdivision' in lookup:
            self.subdivisions = self._q_subdivisions()
        if not lookup or 'WP' in lookup:
            self.wp = self._q_wp()
        if not lookup or 'pws' in lookup:
            self.pws = self._q_pws()
        if not lookup or 'SF' in lookup:
            self.sf = self._q_sf()
        if not lookup or 'organisation' in lookup:
            self.organisations = self._q_organisations()

    def count_results(self):
        ret = 0
        arrays = [self.localities, self.subdivisions, self.wp, self.sf, self.pws, self.organisations]
        for arr in arrays:
            ret += len(arr)
        return ret

    def html_highlight(self, statement):
        if statement and self.query:
            q = self.query.lower()
            tokens = statement.lower().split(q)
            if tokens[0] == '':
                hl = '<strong>%s</strong>' % q.capitalize()
                return hl.join(tokens)
            else:
                hl = '<strong>%s</strong>' % q
                ret = hl.join(tokens)
                return ret.capitalize()
        return statement


    def _q_wp(self):
        return self.session.query(wp_models.WaterpointView).filter(
                or_(wp_models.WaterpointView.upiscode.ilike(self.filter_like), 
                    wp_models.WaterpointView.upisname.ilike(self.filter_like)
                )).order_by(wp_models.WaterpointView.upisname).limit(20).all()


    def _q_sf(self):
        return self.session.query(sf_models.SanitationFacilityView).filter(
                or_(sf_models.SanitationFacilityView.upiscode.ilike(self.filter_like), 
                    sf_models.SanitationFacilityView.upisname.ilike(self.filter_like)
                )).order_by(sf_models.SanitationFacilityView.upisname).limit(20).all()

    def _q_pws(self):
        return self.session.query(pws_models.PWSView).filter(
                or_(pws_models.PWSView.upiscode.ilike(self.filter_like), 
                    pws_models.PWSView.upisname.ilike(self.filter_like)
                )).order_by(pws_models.PWSView.upisname).limit(20).all()

    def _q_subdivisions(self):
        ret = []
        qset = self.session.query(sub_models.Subdivision). \
                filter(or_(
                           sub_models.Subdivision.code.ilike(self.filter_like), 
                           sub_models.Subdivision.name.ilike(self.filter_like)
                           )
                ).order_by(sub_models.Subdivision.name).limit(5).all()
        ret.extend([x for x in qset]) #TODO: CHECK IF NECESSARY
        return ret


    def _q_localities(self):
        return self.session.query(loc_models.Locality).filter(
                or_(loc_models.Locality.adlocode.ilike(self.filter_like), 
                    loc_models.Locality.adloname.ilike(self.filter_like)
                )).order_by(loc_models.Locality.adloname).limit(15).all()

    def _q_organisations(self):
        return self.session.query(org_models.Organisation).filter(
                or_(org_models.Organisation.adorname.ilike(self.filter_like), 
                    org_models.Organisation.adoracronym.ilike(self.filter_like)
                )).order_by(org_models.Organisation.adorname).limit(20).all()


    def _q_catalogs(self):
        return []

#TODO: Add more search functions as we implement
