from sqlalchemy.sql import desc, asc
from sqlalchemy.sql.expression import or_
from ws.common.sql.mappings import Organisation as organisation_models
from ws.common.sql.mappings.Lexicon import LexDRY004

def get_organisation(session, adorcode):
    """
    Retrieve the organisation object by it's id.
    """
    if id:
        return session.query(organisation_models.Organisation).filter(organisation_models.Organisation.adorcode == adorcode).one()

def filter_organisations(session, text='', type='', country='', sort_on='', sort_order=''):
    """
    Filters the list of organisations from Directory
    """
    query = session.query(organisation_models.Organisation)
    if text:
        filter_like = '%%%s%%' % text.strip()
        query = query.filter(or_(organisation_models.Organisation.adorname.ilike(filter_like), organisation_models.Organisation.adoracronym.ilike(filter_like)))
    if type:
        query = query.filter(organisation_models.Organisation.adortype==type)
    if country:
        query = query.filter(organisation_models.Organisation.adorcountry.ilike(country))
    if sort_on:
        column = getattr(organisation_models.Organisation, sort_on)
        if sort_order:
            query = query.order_by(asc(column))
        else:
            query = query.order_by(desc(column))
    return query

def get_organisations(session):
    return session.query(organisation_models.Organisation.adorcode, organisation_models.Organisation.adorname).all()

def get_existing_types(session):
    return session.query(organisation_models.Organisation.adortype, LexDRY004.name).distinct().join(LexDRY004).order_by(LexDRY004.name).all()

def get_types(session):
    return session.query(LexDRY004).order_by(LexDRY004.name).all()

def get_existing_countries(session):
    return session.query(organisation_models.Organisation.adorcountry).distinct().order_by(organisation_models.Organisation.adorcountry).all()
