'''
Created on Jul 9, 2010

@author: cristiroma
'''
from ws.common.sql.mappings import IWRM as iwrm_models
from sqlalchemy.sql.expression import or_, asc, desc

def count_uws(session):
    """ Count the number of underground water sources """
    return session.query(iwrm_models.UWS).count()


def count_monitoring_stations(session):
    """ Count the number of monitoring stations """
    return session.query(iwrm_models.MonitoringStation).count()


def count_basins(session):
    """ Count the number of basins """
    return session.query(iwrm_models.Basin).count()


def count_aquifers(session):
    """ Count the number of aquifers """
    return session.query(iwrm_models.Aquifer).count()


def count_rivers(session):
    """ Count the number of rivers """
    return session.query(iwrm_models.River).count()


def list_uws(session, text, locality, sort_on, sort_order):
    """ Retrieve the list of UWS possible filtered and/or sorted """
    query = session.query(iwrm_models.UWS)
    if text:
        filter_like = '%%%s%%' % text.strip()
        query = query.filter(or_(iwrm_models.UWS.upiscode.ilike(filter_like), iwrm_models.UWS.upisname.ilike(filter_like)))
    if locality:
        query = query.filter_by(adlocode=locality)
    if sort_on:
        column = getattr(iwrm_models.UWS, sort_on)
        if sort_order:
            query = query.order_by(asc(column))
        else:
            query = query.order_by(desc(column))
    return query


def get_uws(session, id):
    """ Retrieve one UWS by its ID 
    """
    return session.query(iwrm_models.UWS).filter_by(upiscode=id).one()


def get_mostation(session, id):
    """ Retrieve one monitoring station by its id (moscode)
    """
    return session.query(iwrm_models.MonitoringStation).filter_by(moscode=id).one()


def get_basin(session, id):
    """ Retrieve one basin by its id (hybcode) 
    """
    return session.query(iwrm_models.Basin).filter_by(hybcode=id).one()


def get_aquifer(session, id):
    """ Retrieve one aquifer by its id (aqfcode)
    """
    return session.query(iwrm_models.Aquifer).filter_by(aqfcode=id).one()


def get_river(session, id):
    """ Retrieve one river by its id (rivcode)
    """
    return session.query(iwrm_models.River).filter_by(rivcode=id).one()
