'''
Created on Apr 27, 2010

@author: cristiroma
'''
from ws.common.sql.mappings.Lexicon import UpistypeEnum
import random
from time import mktime
from datetime import datetime

from ws.common.sql.mappings.SanitationFacility import Sanitation
from ws.common.sql.mappings.Waterpoint import Waterpoint
from ws.common.sql.mappings.Upis import Upis
from ws.common.sql.mappings.Subdivision import SubdivisionView
from ws.common.sql.queries import Access as access_query

from ws.common.utilities import req_field
from ws.common.sql.queries import Access as access_queries

def get_subdivision_hierarchy(session, subdivision):
    """ This method takes one subdivision ID and a list with all parent 
    subdivision in order of hierarchy. For example for subdivision with code
    12345 (which is level 5) returns [Subdivision(1), Subdivision(2),
    Subdivision(3), Subdivision(4)]. In another example, a subdivision with code
    123 will have [Subdivision(1), Subdivision(2)]

    Parameters
        `subdivision`
            Subdivision object whose parent hierarchy will be calculated
    """
    ret = []
    level = subdivision.level
    column = getattr(SubdivisionView, 'level%s' % level)
    row = session.query(SubdivisionView).filter(column == subdivision.code).all()
    if row:
        row = row[0]
        for lv in range(1, level):
            ret.append(getattr(row, 'level%s_ob' % lv))
    return ret


def insert_new_sanitation_facility(session, form):
    dt = datetime.now()
    new_id = 'TMP%s%s' % (int(mktime(dt.timetuple())), random.randint(0, 9999))
    upis = Upis()
    # Mandatory fields
    upis.upiscode = new_id
    upis.upisloctype = form['upisloctype']
    upis.upisobj = form['upisobj']
    upis.upisx = form['upisx']
    upis.upisy = form['upisy']
    upis.upistype = UpistypeEnum.SF
    upis.approved = False
    upis.contributed = True
    upis.upisupdate = form['upisupdate']
    upis.upisupwho = form['upisupwho']

    # Non-mandatory fields
    upis.upisplace = req_field(form, 'upisplace')

    # Locality fields
    adlocode = req_field(form, 'adlocode')
    if adlocode:
        locality = access_query.get_locality_by_code(session, adlocode)
        upis.upisadlocode = locality.adlocode

    # Complete all upisadrXcode fields with values for selected subdivision
    subdivision_code = req_field(form, 'subdivision')
    if subdivision_code:
        subdivision = access_queries.get_subdivision(session, subdivision_code)
        hierarchy = get_subdivision_hierarchy(session, subdivision)
        i = 1
        for ob in hierarchy:
            setattr(upis, 'upisadr%dcode' % i, ob.code)
            i += 1
        setattr(upis, 'upisadr%dcode' % i, subdivision.code)

    point = Sanitation()
    point.upiscode = new_id

    session.add(upis)
    session.flush()
    session.add(point)
    session.flush()

    return (upis, point)


def insert_new_waterpoint(session, form):
    dt = datetime.now()
    new_id = 'TMP%s%s' % (int(mktime(dt.timetuple())), random.randint(0, 9999))
    upis = Upis()

    # Mandatory fields
    # We generate an temporary ID
    upis.upiscode = new_id
    upis.upisloctype = form['upisloctype']
    upis.upisobj = form['upisobj']
    upis.upisx = form['upisx']
    upis.upisy = form['upisy']
    upis.upistype = UpistypeEnum.WP
    upis.approved = False
    upis.contributed = True
    upis.upisupdate = form['upisupdate']
    upis.upisupwho = form['upisupwho']

    # Non-mandatory fields
    upis.upisplace = req_field(form, 'upisplace')
    upis.upwptype = req_field(form, 'upwptype')

    # Locality fields
    adlocode = req_field(form, 'adlocode')
    if adlocode:
        locality = access_query.get_locality_by_code(session, adlocode)
        upis.upisadlocode = locality.adlocode

    # Complete all upisadrXcode fields with values for selected subdivision
    subdivision_code = req_field(form, 'subdivision')
    if subdivision_code:
        subdivision = access_queries.get_subdivision(session, subdivision_code)
        hierarchy = get_subdivision_hierarchy(session, subdivision)
        i = 1
        for ob in hierarchy:
            setattr(upis, 'upisadr%dcode' % i, ob.code)
            i += 1
        setattr(upis, 'upisadr%dcode' % i, subdivision.code)

    point = Waterpoint()
    point.upiscode = new_id
    point.upwpmainuse = form['upwpmainuse']
    session.add(upis)
    session.flush()
    session.add(point)
    session.flush()

    return (upis, point)
