'''
Created on Apr 30, 2010

@author: cristiroma
'''

from sqlalchemy.schema import Table, MetaData, Column
from sqlalchemy.types import String, Float
from sqlalchemy.orm import mapper

metadata = MetaData()

class WatsanCfgValues:
    MAX_PERSONS_EWP = 'max_persons_ewp'
    LEVEL_1_NAME = 'level_1_name'
    LEVEL_2_NAME = 'level_2_name'
    LEVEL_3_NAME = 'level_3_name'
    LEVEL_4_NAME = 'level_4_name'
    LEVEL_5_NAME = 'level_5_name'


table_watsan_cfg = Table('watsan_cfg', metadata,
        Column('id', String, primary_key=True),
        Column('numeric_value', Float),
        Column('string_value', String),
        Column('comment', String)
)

class WatsanCfg(object):
    """ Mapping for upis table (t_upis) """
    def __init__(self, id, numeric_value, string_value, comment):
        self.id = id
        self.numeric_value = numeric_value
        self.string_value = string_value
        self.comment = comment

mapper(WatsanCfg, table_watsan_cfg)


def get_configuration(session):
    ret = {}
    objects = session.query(WatsanCfg).all()
    for ob in objects:
        if ob.numeric_value:
            ret[ob.id] = ob.numeric_value
        else:
            ret[ob.id] = ob.string_value
    return ret