from zope.i18n.locales import locales
from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Float, Text, Date, Boolean, SmallInteger
from sqlalchemy.orm import mapper, relation

from ws.common.sql.mappings.Upis import Upis
from ws.common.sql.mappings import Lexicon as lexicon_models


en = locales.getLocale('en')
formatter = en.numbers.getFormatter('decimal')

metadata = MetaData()
t_wqm = Table('t_wqm', metadata,
        Column('wqmcode', Integer, primary_key=True),   #Report code
        Column('wqmsamplecode', ForeignKey(Upis.upiscode), nullable=False),  #Sample point code (a value of [PWS001] or [WP001] table)
        Column('wqmreference', String),                 #Reference (source) ot the control (Ex: "water quality campaign, year 2009")
        Column('wqmoperator', String),                  #Identification of operator
        Column('wqmdate', Date),                        #Date of the sample
        Column('wqmconformity', Boolean),               #Water quality conformity (Conclusion of the report about quality conformity)
        Column('wqmcomment', Text),                    #Comment on the results
)

class WaterQuality(object):
    """ Mapping for WaterQuality table (t_wqm) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def wqmdate_formatted(self):
        if self.wqmdate:
            return self.wqmdate.strftime('%d %B %Y')

mapper(WaterQuality, t_wqm, properties = {
    'wqmsamplecode_ref': relation(Upis, lazy = True),
})


t_wqmdat = Table('t_wqmdat', metadata,
        Column('wqmdatcode', Integer, primary_key=True),#Measurement code
        Column('wqmdatreportcode', Integer, ForeignKey(WaterQuality.wqmcode), nullable=False), #Report code
        Column('wqmdatparameter', String, ForeignKey(lexicon_models.LexWQD003.code), nullable=False),   #Parameter measured and measurement unit
        Column('wqmdatvalue', String),                  #Measured value
        Column('wqmdatconformity', Date),               #Conformity
)

class WaterQualityData(object):
    """ Mapping for WaterQualityData table (t_wqmdat) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(WaterQualityData, t_wqmdat, properties = {
    'wqmdatreportcode_ref': relation(WaterQuality, lazy = True),
    'wqmdatparameter_ref': relation(lexicon_models.LexWQD003, lazy = False),
})
