# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web
#
# SQL Alchemy mappings for waterpoint tables

from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Float, Date, Integer
from sqlalchemy.orm import mapper
from ws.common.sql.mappings.Locality import Locality
from ws.common.sql.mappings import Lexicon as lex_models
from ws.common.sql.mappings import Program as prog_models
from ws.common.sql.mappings import Subdivision as subdiv_models

metadata = MetaData()
upis_table = Table('t_upis', metadata,
        Column('upiscode', String, primary_key=True),
        Column('upiscodex', String),
        Column('upiscodex2', String),
        Column('upiscodex3', String),
        Column('ishyecode', String),
        Column('upisadlocode', String, ForeignKey(Locality.adlocode)),
        Column('upisadr1code', String, ForeignKey(subdiv_models.Subdivision.code)),
        Column('upisadr2code', String, ForeignKey(subdiv_models.Subdivision.code)),
        Column('upisadr3code', String, ForeignKey(subdiv_models.Subdivision.code)),
        Column('upisadr4code', String, ForeignKey(subdiv_models.Subdivision.code)),
        Column('upisadr5code', String, ForeignKey(subdiv_models.Subdivision.code)),
        Column('upistype', String, ForeignKey(lex_models.LexUpistype.code)),
        Column('upisname', String),
        Column('upisname2', String),
        Column('upisplace', String),
        Column('upisloctype', String, ForeignKey(lex_models.LexUpisloctype.code)),
        Column('upisx', Float), # Longitude
        Column('upisy', Float), # Latitude
        Column('upisz', Float), # Altitude
        Column('upisyear', Integer),
        Column('upisobj', String, ForeignKey(lex_models.LexWP051.code)),
        Column('upisdend', Date),
        Column('upistdesc', String),
        Column('upiscomment', String),
        Column('upismanprof', String, ForeignKey(lex_models.LexUpisManProf.code)),
        Column('upisowner', String),
        Column('upisprogram', Integer, ForeignKey(prog_models.Program.adopcode)),
        Column('upisfinance', String, ForeignKey(lex_models.LexUpisFinance.code)),
        Column('upisupdate', Date),
        Column('upisupwho', String),
        Column('approved', Integer),
        Column('contributed', Integer)
)

class Upis(object):
    """ Mapping for upis table (t_upis) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Upis, upis_table)
