# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
# 
# SQL Alchemy mappings for subdivisions tables. 
# List of 5 objects for each level. Maintainers are welcome :) Fail.

from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, SmallInteger, Float
from sqlalchemy.orm import mapper, relation
import sqlalchemy as sa

metadata = MetaData()

table_adreglev = Table('t_adreglev', metadata, 
        Column('id', Integer, primary_key=True),
        Column('code', String, unique=True),
        Column('codex', String),
        Column('parent_code', String, ForeignKey('t_adreglev.code')),
        Column('level', SmallInteger),
        Column('name', String),
        Column('name_en', String),
)
table_adreglev_parent = sa.alias(table_adreglev, 'parent_adreglev')

class Subdivision(object):
    """
    Mapping for Subdivisions (t_adreglev)
    """
    def __init__(self, id, code, parent_code, level, name, name_en):
        self.id = id
        self.code = code
        self.parent_code = parent_code
        self.level = level
        self.name = name
        self.name_en = name_en

#children_mapper = mapper(Subdivision, table_adreglev_children, non_primary=True)
mapper(Subdivision, table_adreglev, properties = {
    'parent' : relation(Subdivision, lazy=False),
    #'children' : relation(children_mapper, Subdivision, primary_join=sa.and_(table_adreglev_children.c.code == table_adreglev.c.code))
})



table_adreglev_stat = Table('t_adreglev_stat', metadata, 
        Column('id', Integer, primary_key=True),
        Column('code', String, ForeignKey(Subdivision.code), unique=True),
        Column('localities', Integer),
        Column('pop_estimated', Integer),
        Column('households_estimated', Integer),
        Column('pop_served_water', Integer),
        Column('water_access', Float),
        Column('water_functionality_rate', Float),
        Column('water_inventory_rate', Float),
        Column('national_rank', SmallInteger),
        Column('water_points', Integer),
        Column('wp_inventoried', Integer),
        Column('wp_func_equiv', Float),
        Column('wp_nonfunc_equiv', Float),
        Column('pop_served_sanitation', Integer),
        Column('sanitation_access', Float),
        Column('sf_coverage_rate', Float),
        Column('sf_func_rate', Float),
        Column('sf_inventory_rate', Float),
        Column('sf_required', Integer),
        Column('sf_existing_required', Integer),
        Column('sf_existing_inventoried', Integer),
        Column('sf_functional', Integer),
        Column('sf_nonfunctional', Integer),
        Column('school', Integer),
        Column('health', Integer)
)


class SubdivisionStats(object):

    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


    def water_access_formatted(self):
        if self.water_access:
            return '%.2f' % (self.water_access * 100)
        return self.water_access

    def sf_access_formatted(self):
        if self.sf_access:
            return '%.2f' % (self.sf_access * 100)
        return self.sf_access

    def water_inventory_rate_formatted(self):
        if self.water_inventory_rate:
            return '%.2f' % (self.water_inventory_rate * 100)
        return self.water_inventory_rate

    def sanitation_access_formatted(self):
        if self.sanitation_access:
            return '%.2f' % (self.sanitation_access * 100)
        return self.sanitation_access

    def sf_func_rate_formatted(self):
        if self.sf_func_rate:
            return '%.2f' % (self.sf_func_rate * 100)
        return self.sf_func_rate


mapper(SubdivisionStats, table_adreglev_stat, properties = {
    'subdivision' : relation(Subdivision, lazy=False),
})



view_subdivision_locality = Table('view_subdivision_locality', metadata, 
        Column('oid', Integer, primary_key=True),
        Column('level1', String, primary_key=True),
        Column('level2', String, primary_key=True),
        Column('level3', String, primary_key=True),
        Column('level4', String, primary_key=True),
        Column('level5', String, primary_key=True),
        Column('adlocode', String, primary_key=True),
        Column('adloname', String)
)

class SubdivisionLocality(object):

    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(SubdivisionLocality, view_subdivision_locality)



view_subdivision = Table('view_subdivision', metadata, 
        Column('level1', String, ForeignKey(Subdivision.code), primary_key=True),
        Column('level2', String, ForeignKey(Subdivision.code), primary_key=True),
        Column('level3', String, ForeignKey(Subdivision.code), primary_key=True),
        Column('level4', String, ForeignKey(Subdivision.code), primary_key=True),
        Column('level5', String, ForeignKey(Subdivision.code), primary_key=True),
)

class SubdivisionView(object):

    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

#level1_subdivision = sa.alias(table_adreglev, 'subdiv_level1')
#level1_mapper = mapper(Subdivision, level1_subdivision, non_primary=True)

mapper(SubdivisionView, view_subdivision,
       properties=dict(
                       level1_ob=relation(Subdivision, primaryjoin = view_subdivision.c.level1 == table_adreglev.c.code, viewonly=True, lazy = False),
                       level2_ob=relation(Subdivision, primaryjoin = view_subdivision.c.level2 == table_adreglev.c.code, viewonly=True, lazy = False),
                       level3_ob=relation(Subdivision, primaryjoin = view_subdivision.c.level3 == table_adreglev.c.code, viewonly=True, lazy = False),
                       level4_ob=relation(Subdivision, primaryjoin = view_subdivision.c.level4 == table_adreglev.c.code, viewonly=True, lazy = False),
                       level5_ob=relation(Subdivision, primaryjoin = view_subdivision.c.level5 == table_adreglev.c.code, viewonly=True, lazy = False),
    )
)