from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Float, Date, DateTime, Boolean
from sqlalchemy.orm import mapper, relation
from ws.common.sql.mappings import Lexicon as lex_models
from ws.common.sql.mappings.Locality import Locality

metadata = MetaData()
upsf_table = Table('t_upsf', metadata,
        Column('upiscode', String, primary_key=True), # ForeignKey('t_upis.upiscode')
        Column('upsftype', String, ForeignKey(lex_models.LexSF006.code)),
        Column('upsfmatype', String, ForeignKey(lex_models.LexSF012.code)),
        Column('upsfgrtype', String, ForeignKey(lex_models.LexSF013.code)),
        Column('upsfmwsep', String),
        Column('upsfblocnbr', Integer),
        Column('upsfblomnbr', Integer),
        Column('upsfblownbr', Integer),
        Column('upsfshower', String),
        Column('upsfwhand', String),
        Column('upwswbas', String),
        Column('upsfwater', String),
        Column('upsffunc', String, ForeignKey(lex_models.LexSF050.code)),
        Column('upsfnotfr', String, ForeignKey(lex_models.LexSF051.code)),
        Column('upsfnotfd', String, ForeignKey(lex_models.LexSF052.code)),
        Column('upsfasscw', String, ForeignKey(lex_models.LexSF053.code)),
        Column('upsfasspl', String, ForeignKey(lex_models.LexSF054.code)),
        Column('upsfasscl', String, ForeignKey(lex_models.LexSF055.code)),
        Column('upsfpaymd', String, ForeignKey(lex_models.LexSF056.code)),
)

class Sanitation(object):
    """ Mapping for sanitation facilitiy table (t_upsf) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)
mapper(Sanitation, upsf_table)


view_sf = Table('view_sanitation_facility', metadata,
        Column('oid', Integer, primary_key=True),
        # view_subdivision_locality (t_adloc)
        Column('upisadr1code', String),
        Column('upisadr2code', String),
        Column('upisadr3code', String),
        Column('upisadr4code', String),
        Column('upisadr5code', String),
        Column('adlocode', String, ForeignKey(Locality.adlocode)),
        Column('adloname', String),
        # t_upis
        Column('upiscode', String),
        Column('upiscodex', String),
        Column('upistype', String, ForeignKey(lex_models.LexUpistype.code)),
        Column('upisname', String),
        Column('upisname2', String),
        Column('upisplace', String),
        Column('upisloctype', String, ForeignKey(lex_models.LexUpisloctype.code)),
        Column('upisx', Float), # Longitude
        Column('upisy', Float), # Latitude
        Column('upisz', Float),
        Column('upisyear', Integer),
        Column('upisobj', String),
        Column('upisdend', Date),
        Column('upistdesc', String),
        Column('upiscomment', String),
        Column('upismanprof', String, ForeignKey(lex_models.LexUpisManProf.code)),
        Column('upisowner', String),
        Column('upisprogram', String),
        Column('upisfinance', String, ForeignKey(lex_models.LexUpisFinance.code)),
        Column('upisupdate', Date),
        Column('upisupwho', String),
        # t_upsf
        Column('upsftype', String, ForeignKey(lex_models.LexSF006.code)),
        Column('upsfmatype', String, ForeignKey(lex_models.LexSF012.code)),
        Column('upsfgrtype', String, ForeignKey(lex_models.LexSF013.code)),
        Column('upsfmwsep', String),
        Column('upsfblocnbr', Integer),
        Column('upsfblomnbr', Integer),
        Column('upsfblownbr', Integer),
        Column('upsfshower', String),   #, ForeignKey(lex_models.LexSF018.code)),
        Column('upsfwhand', String),    #, ForeignKey(lex_models.LexSF019.code)),
        Column('upwswbas', String),
        Column('upsfwater', String, ForeignKey(lex_models.LexSF021.code)),
        Column('upsffunc', String, ForeignKey(lex_models.LexSF050.code)),
        Column('upsfnotfr', String, ForeignKey(lex_models.LexSF051.code)),
        Column('upsfnotfd', String, ForeignKey(lex_models.LexSF052.code)),
        Column('upsfasscw', String, ForeignKey(lex_models.LexSF053.code)),
        Column('upsfasspl', String, ForeignKey(lex_models.LexSF054.code)),
        Column('upsfasscl', String, ForeignKey(lex_models.LexSF055.code)),
        Column('upsfpaymd', String, ForeignKey(lex_models.LexSF056.code)),
        # lex_wp051
        Column('upisobj_code', String),
        Column('upisobj_name', String),
)

class SanitationFacilityView(object):
    """ Mapping for waterpoint table (t_upwp) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(SanitationFacilityView, view_sf, properties = {
    'locality' : relation(Locality, lazy = False),
    'sftype': relation(lex_models.LexSF006, lazy = False),
    'sfwater': relation(lex_models.LexSF021, lazy = False),
})


view_sanitation_facility_unapproved = Table('view_sanitation_facility_unapproved', metadata,
        Column('oid', Integer, primary_key=True),
        Column('upiscode', String),
        Column('upisloctype', String, ForeignKey(lex_models.LexUpisloctype.code)),
        Column('upisobj', String, ForeignKey(lex_models.LexWP051.code)),
        Column('upisx', Float), # Longitude
        Column('upisy', Float), # Latitude
        Column('adloname', String),
        Column('adlocode', String),
        Column('upisplace', String),
        Column('upisyear', Integer),
        Column('upsftype', String, ForeignKey(lex_models.LexSF006.code)),
        Column('upisupdate', Date),
        Column('upisupwho', String)
)

class SanitationFacilityPendingView(object):
    """ Mapping for view_sanitation_facility_unapproved view """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(SanitationFacilityPendingView, view_sanitation_facility_unapproved)


table_upsfn = Table('t_upsfn', metadata,
        Column('sfnadlocode', String, primary_key=True),
        Column('upsfntype', String, ForeignKey(lex_models.LexSF006.code), primary_key=True),
        Column('upsfnok', Integer),
        Column('upsfnoknot', Integer),
        Column('upsfntot', Integer), 
)

class Upsfn(object): #LOC_SF
    """ Mapping for view_water_point_unapproved view """
    def __init__(self, sfnadlocode, upsfntype, upsfnok, upsfnoknot, upsfntot):
        self.sfnadlocode = sfnadlocode
        self.upsfntype = upsfntype
        self.upsfnok = upsfnok
        self.upsfnoknot = upsfnoknot
        self.upsfntot = upsfntot

mapper(Upsfn, table_upsfn)
