from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Date, Float, Text
from sqlalchemy.orm import mapper, relation
from sqlalchemy.sql.expression import text

from ws.common.sql.mappings.Lexicon import LexDRY004

from ws.common.sql.mappings.Locality import Locality

metadata = MetaData()

table_adorga = Table('t_adorga', metadata,
    Column('adorcode', Integer, primary_key=True),#ID
    Column('adorname', String),                 # Organisation name
    Column('adoracronym', String),              # Organisation acronym
    Column('adortype', String(2), ForeignKey(LexDRY004.code)),      #Type of organisation from category list
    Column('adoradress', String(255)),   # Address
    Column('adorzipcode', String(10)),  # ZIP code
    Column('adorcity', String(64)),     # Town
    Column('adorcountry', String(64)),  # Country
    Column('adortel', String(50)),      # Telephone 
    Column('adorfax', String(50)),      # Fax
    Column('adoremail', String(50)),    # Email address
    Column('adorwebsite', String(50)),  # Website address
    Column('adorlogo', String),     # Logo file name
    Column('adorpres', Text),       #Presentation of the organisation
    Column('adorhqcode', String(20), ForeignKey(Locality.adlocode)), #Locality code where headquarter is located
    Column('adorhqx', Float),       #Longitude  (decimal degree) of the organisation headquarter
    Column('adorhqy', Float),       #Latitude (decimal degree)  of the organisation headquarter
    Column('adorupwho', String),    #Name of the person responsible for last updating data on this organisation
    Column('adorupdate', Date, server_default=text('NOW()')), #Date of last record update
)

class Organisation(object):
    """ Mapping for organisation table (t_adorga) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def edit(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def adoradress_formatted(self):
        return self.adoradress

    def adorwebsite_formatted(self):
        ret = self.adorwebsite
        if ret:
            if ret.startswith('www'):
                ret = '<a href="http://%s">URL</a>' % ret
            elif ret.startswith('http'):
                ret = '<a href="%s">%s</a>' % (ret, ret)
        return ret


mapper(Organisation, table_adorga,
       properties=dict(adortype_ob=relation(LexDRY004)))
