'''
Created on Mar 2, 2010

@author: cristiroma
'''
from zope.i18n.locales import locales
from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Float, Date, Boolean, SmallInteger
from sqlalchemy.orm import mapper, relation
from ws.common.sql.mappings import Subdivision as subdivision_models
from ws.common.sql.mappings import Lexicon as lexicon_models

en = locales.getLocale('en')
formatter = en.numbers.getFormatter('decimal')

metadata = MetaData()
t_adloc = Table('t_adloc', metadata,
        Column('adlocid', Integer, primary_key=True),
        Column('adlocode', String, unique=True),
        Column('loadrcode', String, ForeignKey(subdivision_models.Subdivision.code), nullable=False),
        Column('adlocodex', String),
        Column('adloname', String),
        Column('adloname2', String),
        Column('adlox', Float),
        Column('adloy', Float),
        Column('adlopop', Integer),
        Column('adlopopyear', Integer),
        Column('adlopopgr', Float),
        Column('adlopophh', Float),
        Column('adlostatus', String, ForeignKey(lexicon_models.LexLOC015.code), nullable=False),
        Column('adlohgroup', String, ForeignKey(lexicon_models.LexLOC016.code), nullable=False),
        Column('sf_access', Float),
        Column('adlowamain', String, ForeignKey(lexicon_models.LexLOC041.code), nullable=False),
        Column('adlomarket', Boolean),
        Column('adlovolt', String, ForeignKey(lexicon_models.LexLOC043.code), nullable=False),
        Column('adlotelline', Boolean),
        Column('adlotelmob', Boolean),
        Column('adloweb', Boolean),
        Column('adloupdate', Date),
        Column('adloupwho', String),
        Column('adlosfreq', Integer),
        Column('adloprivwell', Integer),
        Column('adlopubwell', Integer),
        Column('adloprivlatr', Integer),
        Column('adloschool', Integer),
        Column('adlohealth', Integer),
)


class Locality(object):
    """ Mapping for locality table (t_adloc) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def sf_access_formatted(self):
        if self.sf_access:
            return '%.2f' % (self.sf_access * 100)
        return self.sf_access

mapper(Locality, t_adloc, properties = {
    'subdivision': relation(subdivision_models.Subdivision, lazy = False),
    'adlostatus_ob': relation(lexicon_models.LexLOC015, lazy = False),
    'adlohgroup_ob': relation(lexicon_models.LexLOC016, lazy = False),
    'adlowamain_ob': relation(lexicon_models.LexLOC041, lazy = False),
    'adlovolt_ob': relation(lexicon_models.LexLOC043, lazy = False),
})



table_adloc_stat = Table('t_adloc_stat', metadata,
    Column('id', Integer, primary_key=True),
    Column('adlocode', String, ForeignKey(Locality.adlocode)),
    Column('population', Integer),
    Column('adlopopupe', Integer),
    Column('adlohhnbr', Integer),
    Column('pop_served_water', Integer),
    Column('water_access', Float),
    Column('water_functionality_rate', Float),
    Column('water_inventory_rate', Float),
    Column('national_rank', SmallInteger),
    Column('water_points', Integer),
    Column('wp_inventoried', Integer),
    Column('wp_func_equiv', Float),
    Column('wp_nonfunc_equiv', Float),
    Column('pop_served_sanitation', Integer),
    Column('sf_coverage_rate', Float),
    Column('sf_func_rate', Float),
    Column('sf_inventory_rate', Float),
    Column('sf_existing_required', Integer),
    Column('sf_existing_inventoried', Integer),
    Column('sf_functional', Integer),
    Column('sf_nonfunctional', Integer)
)

class LocalityStats(object):
    """ Mapping for locality table (t_adloc_stat) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def water_access_formatted(self):
        if self.water_access:
            return '%.2f' % (self.water_access * 100)
        return self.water_access

    def water_inventory_rate_formatted(self):
        if self.water_inventory_rate:
            return '%.2f' % (self.water_inventory_rate * 100)
        return self.water_inventory_rate

    def sf_inventory_rate_formatted(self):
        if self.sf_inventory_rate:
            return '%.2f' % (self.sf_inventory_rate * 100)
        return self.sf_inventory_rate


mapper(LocalityStats, table_adloc_stat, properties = {
    'locality': relation(Locality, lazy = True),
})

view_locality_statistics = Table('view_locality_statistics', metadata, 
        Column('adlocode', String, primary_key=True),   #Unique locality code defined by official producer
        Column('adloname', String), #Name defined by official producer
        Column('population', Integer),  #Calculated population of the present year
        Column('water_access', Float),  #Access rate to safe water estimated by survey
        Column('sf_access', Float), #Access rate to sanitation estimated by survey
        Column('pop_served_water', Integer),    #Population served with safe water
        Column('pop_served_sanitation', Integer),   # Population served with sanitation
        Column('level1', String),   #Subdivision level 1
        Column('level2', String),   #Subdivision level 2
        Column('level3', String),   #Subdivision level 3
        Column('level4', String),   #Subdivision level 4
        Column('level5', String)    #Subdivision level 5
)
class LocalityStatsView(object):
    """ Mapping for locality statistics view (view_locality_statistics) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def population_formatted(self):
        if self.population:
            return formatter.format(self.population)
        return self.population

    def water_access_formatted(self):
        if self.water_access:
            return '%.2f' % (self.water_access * 100)

    def sf_access_formatted(self):
        if self.sf_access:
            return '%.2f' % (self.sf_access * 100)

mapper(LocalityStatsView, view_locality_statistics)