# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Andrei Laza, Eau De Web
#
# SQL Alchemy mappings for country table

from sqlalchemy.schema import Table, MetaData, Column
from sqlalchemy.types import String, Float
from sqlalchemy.orm import mapper

metadata = MetaData()

##################################################
# Constants - These are immutable values
class InfrastructureLocationType:
    """
    Decoding of column t_upis.upisloctype(LexUpisloctype) - WP008 and SF007.
    """
    PUBLIC_AREA = '01'
    PRIVATE_HOME = '02'
    EDUCATIONAL_INFRASTRUCTURE = '03'
    HEALTH_INFRASTRUCTURE = '04'
    OTHER_INFRASTRUCTURE = '05'
    WORSHIP_PLACE = '06'
    RESTAURANT_SHOP = '07'
    AGRICULTURAL = '08'
    INDUSTRY = '09'
    MARKET = '10'
    BUS_STATION = '11'
    TRADITIONAL_WELL = '37'
    MARKET_PLACE = '51'
    BOREHOLE_NOT_EQUIPPED = '97'
    OTHER = '98'
    UNKNOWN = '99'


class WaterPointType:
    """ Decoding of column t_upwp.upwptype(WP007) - LexWP007 """
    PUBLIC_TAP = '01'
    HANDPUMP_ON_BOREHOLE = '02'
    HANDPUMP_ON_MODERN_WELL = '03'
    MODERN_WELL = '04'
    TANK_WELL = '05'
    COMMUNITY_CONNECTION = '06'
    HOUSEHOLD_CONNECTION = '07'
    WATER_POST_FOR_CARTS = '08'
    FITTED_OUT_SPRING = '09'
    GARDENING_TANK = '10'
    RAINWATER_HARVESTING = '11'
    CATTLE_DROUGH = '12'
    SELF_STANDING = '13'
    OTHER = '98'


class UpisFunctionality:
    """ Decoding of column t_upis.upisobj - LexWP051 - LexSF050 """
    IN_SERVICE = '01'
    OUT_OF_ORDER = '02'
    NOT_USED = '03'
    DESTROYED = '04'


class PWSFunctionality:
    """ Decoding of column t_upis.upisobj - LexWP051 - LexSF050 """
    IN_SERVICE = '01'
    OUT_OF_ORDER = '02'
    NOT_USED = '03'
    UNKNOWN = '99'


class SanitationFacilityType:
    """ Decoding of column t_upwp.upsftype(SF006) - LexSF006 """
    SANPLAT_LATRINES = '01'
    ECOSAN_LATRINES_LATRINES = '02'
    FLUSH_LATRINES = '03'
    VIP_LATRINES = '04'
    SEPTIC_TANK_LATRINES = '05'
    TRADITIONAL_LATRINES = '06'
    CONNECTION_TO_COLLECTIVE = '07'
    CONNECTION_TO_SEMICOLLECTIVE = '08'
    PUBLIC_TOILET_FLUSH_LATRINES = '09'
    PUBLIC_TOILET_VIP_LATRINES = '10'
    PUBLIC_TOILET_VIP_SEPTIC_TANK_LATRINES = '11'
    PUBLIC_TOILET_TRADITIONAL_LATRINES = '12'
    PUBLIC_TOILET_ON_COLLECTIVE = '13'
    PUBLIC_TOILET_ON_SEMICOLLECTIVE = '14'
    OTHER = '98'
    UNKNOWN = '99'


class UpistypeEnum:
    WP = 'WP' #Water point
    SF = 'SF' #Sanitation facility
    PWS = 'PWS' #Piped water scheme
    UWS = 'UWS' #Underground water supply
    BAS = 'BAS' #Basin
##################################################


lex_upismanprof = Table('lex_upismanprof', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexUpisManProf(object):
    """
    Mapping for Lexicon UpisManProf (lex_upismanprof)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexUpisManProf, lex_upismanprof)


lex_upisfinance = Table('lex_upisfinance', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexUpisFinance(object):
    """
    Mapping for Lexicon LexUpisFinance (lex_upisfinance)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexUpisFinance, lex_upisfinance)


table_lex_upisloctype = Table('lex_upisloctype', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexUpisloctype(object):
    """
    Represents the location of an infrastructure.
    Mapping for Lexicon LexUpisloctype (lex_upisloctype). This lexicon is the
    merge of two lexicons that hold the same values: WP008 and SF007.
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexUpisloctype, table_lex_upisloctype)


# Customized because it has a new column: ewp
wp007_table = Table('lex_wp007', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
        Column('ewp', Float),
)

class LexWP007(object):
    """
    Mapping for Lexicon WP007 (lex_wp007)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexWP007, wp007_table)


table_lex_upistype = Table('lex_upistype', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexUpistype(object):
    """
    Represents the type of an infrastructure. (WP/SF/PWS/UWS etc.)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexUpistype, table_lex_upistype)


table_lex_opb005 = Table('lex_opb005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexOpb005(object):
    """
    Represents the type of funding. (Grant/Soft loan/Commercial loan etc.)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(LexOpb005, table_lex_opb005)



cooling_table = Table('lex_cooling', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)
class LexCooling(object):
    """
    Mapping for Lexicon cooling (lex_cooling)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)
mapper(LexCooling, cooling_table)



##################################################



loc015_table = Table('lex_loc015', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

loc016_table = Table('lex_loc016', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

loc021_table = Table('lex_loc021', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

loc041_table = Table('lex_loc041', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

loc043_table = Table('lex_loc043', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp009_table = Table('lex_wp009', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp017_table = Table('lex_wp017', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp051_table = Table('lex_wp051', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp052_table = Table('lex_wp052', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp053_table = Table('lex_wp053', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp055_table = Table('lex_wp055', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp056_table = Table('lex_wp056', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp057_table = Table('lex_wp057', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp058_table = Table('lex_wp058', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp059_table = Table('lex_wp059', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp060_table = Table('lex_wp060', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp061_table = Table('lex_wp061', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp062_table = Table('lex_wp062', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp063_table = Table('lex_wp063', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp064_table = Table('lex_wp064', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp065_table = Table('lex_wp065', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp066_table = Table('lex_wp066', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp067_table = Table('lex_wp067', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp071_table = Table('lex_wp071', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp074_table = Table('lex_wp074', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp075_table = Table('lex_wp075', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp076_table = Table('lex_wp076', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp077_table = Table('lex_wp077', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wp080_table = Table('lex_wp080', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf006_table = Table('lex_sf006', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf012_table = Table('lex_sf012', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf013_table = Table('lex_sf013', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf021_table = Table('lex_sf021', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf050_table = Table('lex_sf050', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf051_table = Table('lex_sf051', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf052_table = Table('lex_sf052', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf053_table = Table('lex_sf053', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf054_table = Table('lex_sf054', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf055_table = Table('lex_sf055', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

sf056_table = Table('lex_sf056', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws005_table = Table('lex_pws005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws007_table = Table('lex_pws007', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws020_table = Table('lex_pws020', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws024_table = Table('lex_pws024', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws025_table = Table('lex_pws025', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pws027_table = Table('lex_pws027', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwi003_table = Table('lex_pwi003', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwp004_table = Table('lex_pwp004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwp005_table = Table('lex_pwp005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwp007_table = Table('lex_pwp007', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwe003_table = Table('lex_pwe003', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwss003_table = Table('lex_pwss003', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwss004_table = Table('lex_pwss004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

pwt002_table = Table('lex_pwt002', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)


dry004_table = Table('lex_dry004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cge004_table = Table('lex_cge004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cge007_table = Table('lex_cge007', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cge008_table = Table('lex_cge008', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cpv004_table = Table('lex_cpv004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cin006_table = Table('lex_cin006', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cpp004_table = Table('lex_cpp004', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

chp005_table = Table('lex_chp005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cwm005_table = Table('lex_cwm005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

cwm006_table = Table('lex_cwm006', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

uws005_table = Table('lex_uws005', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

uws012_table = Table('lex_uws012', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)

wqd003_table = Table('lex_wqd003', metadata,
        Column('code', String(2), primary_key=True),
        Column('name', String),
        Column('name2', String),
)




class LexLOC015(object):
    """
    Mapping for Lexicon LOC015 (lex_loc015)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexLOC016(object):
    """
    Mapping for Lexicon LOC016 (lex_loc016)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexLOC021(object):
    """
    Mapping for Lexicon LOC021 (lex_loc021)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexLOC041(object):
    """
    Mapping for Lexicon LOC041 (lex_loc041)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexLOC043(object):
    """
    Mapping for Lexicon LOC043 (lex_loc043)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP009(object):
    """
    Mapping for Lexicon WP009 (lex_wp009)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP017(object):
    """
    Mapping for Lexicon WP017 (lex_wp017)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP051(object):
    """
    Mapping for Lexicon WP051 (lex_wp051)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP052(object):
    """
    Mapping for Lexicon WP052 (lex_wp052)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP053(object):
    """
    Mapping for Lexicon WP053 (lex_wp053)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP055(object):
    """
    Mapping for Lexicon WP055 (lex_wp055)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP056(object):
    """
    Mapping for Lexicon WP056 (lex_wp056)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP057(object):
    """
    Mapping for Lexicon WP057 (lex_wp057)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP058(object):
    """
    Mapping for Lexicon WP058 (lex_wp058)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP059(object):
    """
    Mapping for Lexicon WP059 (lex_wp059)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

class LexWP060(object):
    """
    Mapping for Lexicon WP060 (lex_wp060)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP061(object):
    """
    Mapping for Lexicon WP061 (lex_wp061)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP062(object):
    """
    Mapping for Lexicon WP062 (lex_wp062)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP063(object):
    """
    Mapping for Lexicon WP063 (lex_wp063)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP064(object):
    """
    Mapping for Lexicon WP064 (lex_wp064)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP065(object):
    """
    Mapping for Lexicon WP065 (lex_wp065)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP066(object):
    """
    Mapping for Lexicon WP066 (lex_wp066)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP067(object):
    """
    Mapping for Lexicon WP067 (lex_wp067)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP071(object):
    """
    Mapping for Lexicon WP071 (lex_wp071)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP074(object):
    """
    Mapping for Lexicon WP074 (lex_wp074)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP075(object):
    """
    Mapping for Lexicon WP075 (lex_wp075)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP076(object):
    """
    Mapping for Lexicon WP076 (lex_wp076)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP077(object):
    """
    Mapping for Lexicon WP077 (lex_wp077)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWP080(object):
    """
    Mapping for Lexicon WP080 (lex_wp080)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF006(object):
    """
    Mapping for Lexicon SF006 (lex_sf006)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF012(object):
    """
    Mapping for Lexicon SF012 (lex_sf012)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF013(object):
    """
    Mapping for Lexicon SF013 (lex_sf013)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF021(object):
    """
    Mapping for Lexicon SF021 (lex_sf021)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF050(object):
    """
    Mapping for Lexicon SF050 (lex_sf050)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF051(object):
    """
    Mapping for Lexicon SF051 (lex_sf051)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF052(object):
    """
    Mapping for Lexicon SF052 (lex_sf052)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF053(object):
    """
    Mapping for Lexicon SF053 (lex_sf053)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF054(object):
    """
    Mapping for Lexicon SF054 (lex_sf054)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF055(object):
    """
    Mapping for Lexicon SF055 (lex_sf055)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexSF056(object):
    """
    Mapping for Lexicon SF056 (lex_sf056)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS005(object):
    """
    Mapping for Lexicon PWS005 (lex_pws005)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS007(object):
    """
    Mapping for Lexicon PWS007 (lex_pws007)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS020(object):
    """
    Mapping for Lexicon PWS020 (lex_pws020)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS024(object):
    """
    Mapping for Lexicon PWS024 (lex_pws024)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS025(object):
    """
    Mapping for Lexicon PWS025 (lex_pws025)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWS027(object):
    """
    Mapping for Lexicon PWS027 (lex_pws027)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWI003(object):
    """
    Mapping for Lexicon PWI003 (lex_pwi003)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWP004(object):
    """
    Mapping for Lexicon PWP004 (lex_pwp004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWP005(object):
    """
    Mapping for Lexicon PWP005 (lex_pwp005)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWP007(object):
    """
    Mapping for Lexicon PWP007 (lex_pwp007)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWE003(object):
    """
    Mapping for Lexicon PWE003 (lex_pwe003)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWSS003(object):
    """
    Mapping for Lexicon PWSS003 (lex_pwss003)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWSS004(object):
    """
    Mapping for Lexicon PWSS004 (lex_pwss004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexPWT002(object):
    """
    Mapping for Lexicon PWT002 (lex_pwt002)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexDRY004(object):
    """
    Mapping for Lexicon DRY004 (lex_dry004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCGE004(object):
    """
    Mapping for Lexicon CGE004 (lex_cge004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCGE007(object):
    """
    Mapping for Lexicon CGE007 (lex_cge007)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCGE008(object):
    """
    Mapping for Lexicon CGE008 (lex_cge008)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCPV004(object):
    """
    Mapping for Lexicon CPV004 (lex_cpv004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCIN006(object):
    """
    Mapping for Lexicon CIN006 (lex_cin006)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCPP004(object):
    """
    Mapping for Lexicon CPP004 (lex_cpp004)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCHP005(object):
    """
    Mapping for Lexicon CHP005 (lex_chp005)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCWM005(object):
    """
    Mapping for Lexicon CWM005 (lex_cwm005)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexCWM006(object):
    """
    Mapping for Lexicon CWM006 (lex_cwm006)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexUWS005(object):
    """
    Mapping for Lexicon UWS005 (lex_uws005)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexUWS012(object):
    """
    Mapping for Lexicon UWS012 (lex_uws012)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


class LexWQD003(object):
    """
    Mapping for Lexicon WQD003 (lex_wqd003)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)


mapper(LexLOC015, loc015_table)
mapper(LexLOC016, loc016_table)
mapper(LexLOC021, loc021_table)
mapper(LexLOC041, loc041_table)
mapper(LexLOC043, loc043_table)
mapper(LexWP009, wp009_table)
mapper(LexWP017, wp017_table)
mapper(LexWP051, wp051_table)
mapper(LexWP052, wp052_table)
mapper(LexWP053, wp053_table)
mapper(LexWP055, wp055_table)
mapper(LexWP056, wp056_table)
mapper(LexWP057, wp057_table)
mapper(LexWP058, wp058_table)
mapper(LexWP059, wp059_table)
mapper(LexWP060, wp060_table)
mapper(LexWP061, wp061_table)
mapper(LexWP062, wp062_table)
mapper(LexWP063, wp063_table)
mapper(LexWP064, wp064_table)
mapper(LexWP065, wp065_table)
mapper(LexWP066, wp066_table)
mapper(LexWP067, wp067_table)
mapper(LexWP071, wp071_table)
mapper(LexWP074, wp074_table)
mapper(LexWP075, wp075_table)
mapper(LexWP076, wp076_table)
mapper(LexWP077, wp077_table)
mapper(LexWP080, wp080_table)
mapper(LexSF006, sf006_table)
mapper(LexSF012, sf012_table)
mapper(LexSF013, sf013_table)
mapper(LexSF021, sf021_table)
mapper(LexSF050, sf050_table)
mapper(LexSF051, sf051_table)
mapper(LexSF052, sf052_table)
mapper(LexSF053, sf053_table)
mapper(LexSF054, sf054_table)
mapper(LexSF055, sf055_table)
mapper(LexSF056, sf056_table)
mapper(LexPWS005, pws005_table)
mapper(LexPWS007, pws007_table)
mapper(LexPWS020, pws020_table)
mapper(LexPWS024, pws024_table)
mapper(LexPWS025, pws025_table)
mapper(LexPWS027, pws027_table)
mapper(LexPWI003, pwi003_table)
mapper(LexPWP004, pwp004_table)
mapper(LexPWP005, pwp005_table)
mapper(LexPWP007, pwp007_table)
mapper(LexPWE003, pwe003_table)
mapper(LexPWSS003, pwss003_table)
mapper(LexPWSS004, pwss004_table)
mapper(LexPWT002, pwt002_table)
mapper(LexDRY004, dry004_table)
mapper(LexCGE004, cge004_table)
mapper(LexCGE007, cge007_table)
mapper(LexCGE008, cge008_table)
mapper(LexCPV004, cpv004_table)
mapper(LexCIN006, cin006_table)
mapper(LexCPP004, cpp004_table)
mapper(LexCHP005, chp005_table)
mapper(LexCWM005, cwm005_table)
mapper(LexCWM006, cwm006_table)
mapper(LexUWS005, uws005_table)
mapper(LexUWS012, uws012_table)
mapper(LexWQD003, wqd003_table)




lexicon_list = {
############ DO NOT OVERRIDE ################################
    'LexUpisManProf' : {
        'table_name' : 'Water point management profile',
        'table_class': LexUpisManProf,
    },
    'LexUpisFinance' : {
        'table_name' : 'Source of financing',
        'table_class': LexUpisFinance,
    },
    'LexUpisloctype' : {
        'table_name' : 'Type of location for facility',
        'table_class': LexUpisloctype,
    },

    'LexUpistype' : {
        'table_name' : 'Represents the type of an infrastructure. (WP/SF/PWS/UWS etc.)',
        'table_class': LexUpistype,
    },

    'LexOpb005' : {
        'table_name' : 'Represents the type of funding. (Grant/Soft loan/Commercial loan etc.)',
        'table_class': LexOpb005,
    },
    'LexCooling' : {
        'table_name' : 'Cooling system',
        'table_class': LexCooling,
    },
#############################################################

    'LexLOC015' : {
        'table_name' : 'Urban / semi-urban / rural status',
        'table_class': LexLOC015,
    },
    'LexLOC016' : {
        'table_name' : 'Type of habitat grouping of the locality',
        'table_class': LexLOC016,
    },
    'LexLOC021' : {
        'table_name' : 'National rank of the locality for access to water',
        'table_class': LexLOC021,
    },
    'LexLOC041' : {
        'table_name' : 'Main access to water',
        'table_class': LexLOC041,
    },
    'LexLOC043' : {
        'table_name' : 'Locality served with a low voltage grid',
        'table_class': LexLOC043,
    },
    'LexWP007' : {
        'table_name' : 'Type of water point',
        'table_class': LexWP007,
    },
    'LexWP009' : {
        'table_name' : 'Principal use of the water point',
        'table_class': LexWP009,
    },
    'LexWP017' : {
        'table_name' : 'Benchmarking of the water point by the users',
        'table_class': LexWP017,
    },
    'LexWP051' : {
        'table_code': '',
        'table_name' : 'Functionality of the water point',
        'table_class': LexWP051,
    },
    'LexWP052' : {
        'table_code': '',
        'table_name' : 'Reasons for non functionality',
        'table_class': LexWP052,
    },
    'LexWP053' : {
        'table_name' : 'Duration of non functionality',
        'table_class': LexWP053,
    },
    'LexWP055' : {
        'table_name' : 'Assessment of civil works on the water point',
        'table_class': LexWP055,
    },
    'LexWP056' : {
        'table_name' : 'Assessment of plumbering on the water point',
        'table_class': LexWP056,
    },
    'LexWP057' : {
        'table_name' : 'Assessment of hygiene around the water point',
        'table_class': LexWP057,
    },
    'LexWP058' : {
        'table_name' : 'Fencing of the water point',
        'table_class': LexWP058,
    },
    'LexWP059' : {
        'table_name' : 'Turbidity of water',
        'table_class': LexWP059,
    },
    'LexWP060' : {
        'table_name' : 'Taste of water',
        'table_class': LexWP060,
    },
    'LexWP061' : {
        'table_name' : 'Odor of water',
        'table_class': LexWP061,
    },
    'LexWP062' : {
        'table_name' : 'System of water treatment on the water point',
        'table_class': LexWP062,
    },
    'LexWP063' : {
        'table_name' : 'Functionality of the system of water treatment',
        'table_class': LexWP063,
    },
    'LexWP064' : {
        'table_name' : 'Modalities for the payment of water on the water point',
        'table_class': LexWP064,
    },
    'LexWP065' : {
        'table_name' : 'Seasonability of the payment of water on the water point',
        'table_class': LexWP065,
    },
    'LexWP066' : {
        'table_name' : 'Brand/Type of the handpump',
        'table_class': LexWP066,
    },
    'LexWP067' : {
        'table_name' : 'Functionality of the handpump',
        'table_class': LexWP067,
    },
    'LexWP071' : {
        'table_name' : 'Functionality of the water metering system',
        'table_class': LexWP071,
    },
    'LexWP074' : {
        'table_name' : 'Protection area against contamination by latrines',
        'table_class': LexWP074,
    },
    'LexWP075' : {
        'table_name' : 'Drying up of the water point',
        'table_class': LexWP075,
    },
    'LexWP076' : {
        'table_name' : 'Closing system on the well',
        'table_class': LexWP076,
    },
    'LexWP077' : {
        'table_name' : 'Water abstraction system on the well',
        'table_class': LexWP077,
    },
    'LexWP080' : {
        'table_name' : 'Sale unit',
        'table_class': LexWP080,
    },
    'LexSF006' : {
        'table_name' : 'Type of sanitation facility',
        'table_class': LexSF006,
    },
    'LexSF012' : {
        'table_name' : 'Type of building materials',
        'table_class': LexSF012,
    },
    'LexSF013' : {
        'table_name' : 'Type of ground',
        'table_class': LexSF013,
    },
    'LexSF021' : {
        'table_name' : 'Availability of water ate the sanitation facility',
        'table_class': LexSF021,
    },
    'LexSF050' : {
        'table_name' : 'Functionality of the sanitation facility',
        'table_class': LexSF050,
    },
    'LexSF051' : {
        'table_name' : 'Reasons for non functionality',
        'table_class': LexSF051,
    },
    'LexSF052' : {
        'table_name' : 'Duration of non functionality',
        'table_class': LexSF052,
    },
    'LexSF053' : {
        'table_name' : 'Assessment of civil works on the sanitation facility',
        'table_class': LexSF053,
    },
    'LexSF054' : {
        'table_name' : 'Assessment of plumbering on the sanitation facility',
        'table_class': LexSF054,
    },
    'LexSF055' : {
        'table_name' : 'Assessment of cleanliness on the sanitation facility',
        'table_class': LexSF055,
    },
    'LexSF056' : {
        'table_name' : 'Modalities for the payment on the sanitation facility',
        'table_class': LexSF056,
    },
    'LexPWS005' : {
        'table_name' : 'Ownership of the scheme',
        'table_class': LexPWS005,
    },
    'LexPWS007' : {
        'table_name' : 'Contracting arrangement',
        'table_class': LexPWS007,
    },
    'LexPWS020' : {
        'table_name' : 'Functionality of the scheme',
        'table_class': LexPWS020,
    },
    'LexPWS024' : {
        'table_name' : 'Energy source(s) configuration',
        'table_class': LexPWS024,
    },
    'LexPWS025' : {
        'table_name' : 'Extent of piped scheme',
        'table_class': LexPWS025,
    },
    'LexPWS027' : {
        'table_name' : 'Type of water resource abstracted',
        'table_class': LexPWS027,
    },
    'LexPWI003' : {
        'table_name' : 'Category of pipe',
        'table_class': LexPWI003,
    },
    'LexPWP004' : {
        'table_name' : 'Category of water source',
        'table_class': LexPWP004,
    },
    'LexPWP005' : {
        'table_name' : 'Category of pump',
        'table_class': LexPWP005,
    },
    'LexPWP007' : {
        'table_name' : 'Category of energy required for the pump',
        'table_class': LexPWP007,
    },
    'LexPWE003' : {
        'table_name' : 'Category of energy source',
        'table_class': LexPWE003,
    },
    'LexPWSS003' : {
        'table_name' : 'Category of reservoir',
        'table_class': LexPWSS003,
    },
    'LexPWSS004' : {
        'table_name' : 'Building material of the tank',
        'table_class': LexPWSS004,
    },
    'LexPWT002' : {
        'table_name' : 'Type of water treatment',
        'table_class': LexPWT002,
    },
    'LexDRY004' : {
        'table_name' : 'Category of organization',
        'table_class': LexDRY004,
    },
    'LexCGE004' : {
        'table_name' : 'Fuel type',
        'table_class': LexCGE004,
    },

    'LexCGE007' : {
        'table_name' : 'Nominal voltage and nb. of phases of alternator',
        'table_class': LexCGE007,
    },
    'LexCGE008' : {
        'table_name' : 'Nominal frequence of alternator (Hz)',
        'table_class': LexCGE008,
    },
    'LexCPV004' : {
        'table_name' : 'Cell technology',
        'table_class': LexCPV004,
    },
    'LexCIN006' : {
        'table_name' : 'Type of modulation',
        'table_class': LexCIN006,
    },
    'LexCPP004' : {
        'table_name' : 'Type of pump',
        'table_class': LexCPP004,
    },
    'LexCHP005' : {
        'table_name' : 'Type of handpump',
        'table_class': LexCHP005,
    },
    'LexCWM005' : {
        'table_name' : 'Type of water meter',
        'table_class': LexCWM005,
    },
    'LexCWM006' : {
        'table_name' : 'Precision class',
        'table_class': LexCWM006,
    },
    'LexUWS005' : {
        'table_name' : 'Type of source',
        'table_class': LexUWS005,
    },
    'LexUWS012' : {
        'table_name' : 'Catched aquifer',
        'table_class': LexUWS012,
    },
    'LexWQD003' : {
        'table_name' : 'Parameter measured and measurement unit',
        'table_class': LexWQD003,
    },
}
