'''
Created on Mar 2, 2010

@author: cristiroma
'''
from zope.i18n.locales import locales
from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Float, Date, SmallInteger
from sqlalchemy.orm import mapper, relation
from ws.common.sql.mappings.Subdivision import Subdivision
from ws.common.sql.mappings.Locality import Locality
from ws.common.sql.mappings import Lexicon as lex_models

en = locales.getLocale('en')
formatter = en.numbers.getFormatter('decimal')

metadata = MetaData()


t_hyentity = Table('t_hyentity', metadata,
        Column('hyecode', Integer, primary_key=True),
        Column('hyeupdate', Date),
        Column('hyewho', String),
)

class HydrographicEntity(object):
    """ Mapping for basin table (t_hyentity) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(HydrographicEntity, t_hyentity)



t_hymostation = Table('t_hymostation', metadata,
        Column('moscode', Integer, ForeignKey(HydrographicEntity.hyecode), primary_key=True),
        Column('moscodex', String, unique=True),
        Column('mosnamee', String),
        Column('smoncode', String),
        Column('mslocation', String),
        Column('mosx', Float),
        Column('mosy', Float),
        Column('mosz', Float),
        Column('mostypee', String),
        Column('mosyearsta', Integer),
        Column('mosyearmdif', Integer),
        Column('mosyearend', Integer),
        Column('mossit', String),
        Column('mosknext', Float),
        Column('moscatha', Float),
        Column('moscomm', String),
        Column('manres', String),
)


class MonitoringStation(object):
    """ Mapping for monitoring station table (t_hymostation) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(MonitoringStation, t_hymostation)



t_hybasin = Table('t_hybasin', metadata,
        Column('hybcode', Integer, ForeignKey(HydrographicEntity.hyecode), primary_key=True, nullable=False),
        Column('hybname', String),
        Column('hybdesc', String),
        Column('hybsurf', Float),
)


class Basin(object):
    """ Mapping for basin table (t_hybasin) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Basin, t_hybasin)



t_hyriver = Table('t_hyriver', metadata,
        Column('rivcode', Integer, ForeignKey(HydrographicEntity.hyecode), primary_key=True, nullable=False),
        Column('hybascode', Integer, ForeignKey(Basin.hybcode)),
        Column('rivdesc', String),
)


class River(object):
    """ Mapping for river table (t_hyriver) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(River, t_hyriver, properties = {
        'hybascode_ob': relation(Basin, lazy = True)
})



t_hyaquifer = Table('t_hyaquifer', metadata,
        Column('aqfcode', Integer, ForeignKey(HydrographicEntity.hyecode), primary_key=True, nullable=False),
        Column('aqfname', String),
)


class Aquifer(object):
    """ Mapping for river table (t_hyaquifer) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Aquifer, t_hyaquifer)



view_gis_uws = Table('view_gis_uws', metadata,
        Column('upiscode', String, primary_key=True),
        Column('upisname', String),
        Column('upisadr1code', String, ForeignKey(Subdivision.code)),
        Column('upisadr2code', String, ForeignKey(Subdivision.code)),
        Column('upisadr3code', String, ForeignKey(Subdivision.code)),
        Column('upisadr4code', String, ForeignKey(Subdivision.code)),
        Column('upisadr5code', String, ForeignKey(Subdivision.code)),
        Column('upisadlocode', String, ForeignKey(Locality.adlocode)),
        Column('adloname', String),
        Column('upwputype', String, ForeignKey(lex_models.LexUWS005.code)),
        Column('upwputype_name', String),
        Column('upisyear', Integer),
        Column('upwpwlev', Float),
        Column('upwpdiam', Float),
        Column('upwpdepth', Float),
        Column('upwpuyelm', Float),
        Column('upwpudepin', SmallInteger),
        Column('fk_aqfcode', Integer, ForeignKey(Aquifer.aqfcode)),
        Column('upisx', Float),
        Column('upisy', Float),
        Column('aqfname', String),
        Column('upwpudraw', String),
)


class UWS(object):
    """ Mapping for UWS view (view_gis_uws) """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)
            
    def upwpwlev_formatted(self):
        if self.upwpwlev is not None:
            return formatter.format(self.upwpwlev)

    def upwpdiam_formatted(self):
        if self.upwpdiam is not None:
            return formatter.format(self.upwpdiam)

    def upwpdepth_formatted(self):
        if self.upwpdepth is not None:
            return formatter.format(self.upwpdepth)

    def upwpuyelm_formatted(self):
        if self.upwpuyelm is not None:
            return formatter.format(self.upwpuyelm)


mapper(UWS, view_gis_uws, properties = {
        'upisadlocode_ob': relation(Locality, lazy = True),
        'upwputype_ob': relation(lex_models.LexUWS005, lazy = True),
        'fk_aqfcode_ob': relation(Aquifer, lazy = True)
    }
)

