# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
#
# SQL Alchemy mappings for country table

from sqlalchemy.schema import Table, MetaData, Column
from sqlalchemy.types import String, Integer, Float
from sqlalchemy.orm import mapper

metadata = MetaData()


table_country = Table('t_adcountry', metadata,
        Column('adcncodex', String(2), primary_key=True),
        Column('adcnname', String),
        Column('adcnname2', String),
        Column('adcnnameov', String),
        Column('adcnurlwat', String),
        Column('total_population', Integer),
        Column('rural_population', Integer),
        Column('urban_population', Integer),
        Column('water_access_rural', Float),
        Column('water_access_rural_byconn', Float),
        Column('water_access_urban', Float),
        Column('water_access_urban_byconn', Float),
        Column('sanitation_access_rural', Float),
        Column('sanitation_access_urban', Float),
        Column('year', Integer)
)


class Country(object):
    """
    Mapping for country table (t_adcountry)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(Country, table_country)


table_adcountry_stat = Table('t_adcountry_stat', metadata,
        Column('year', Integer, primary_key=True),
        Column('water_access_rural', Float),
        Column('water_access_urban', Float),
        Column('sanitation_access_rural', Float),
        Column('sanitation_access_urban', Float)
)

class CountryStat(object):

    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

mapper(CountryStat, table_adcountry_stat)
