'''
Created on May 3, 2010

@author: cristiroma
'''
import time
from datetime import datetime

from sqlalchemy.schema import Table, MetaData, Column, ForeignKey
from sqlalchemy.types import String, Integer, Float, Boolean, TIMESTAMP
from sqlalchemy.orm import mapper, relation
from ws.common.sql.mappings import Lexicon as lex_models
from ws.common.sql.query import get_lexicon_row_by_classname


metadata = MetaData()

t_cat_attribute = Table('t_cat_attribute', metadata, 
        Column('id_attribute', String, primary_key=True),
        Column('name', String),
        Column('is_string', Boolean),
        Column('is_integer', Boolean),
        Column('is_real', Boolean),
        Column('is_bool', Boolean),
        Column('is_lexicon', Boolean),
        Column('is_url', Boolean),
        Column('is_picture', Boolean),
        Column('lexicon_klass', Boolean),
        Column('enabled', Boolean),
        Column('reference', Boolean),
        Column('created', TIMESTAMP),
        Column('author', String)
)

class CatAttribute(object):
    """
    Mapping for attributes table (t_cat_attribute)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def get_lexicon_name(self):
        if self.is_lexicon \
                and self.lexicon_klass \
                and lex_models.lexicon_list.has_key(self.lexicon_klass):
            return lex_models.lexicon_list[self.lexicon_klass]['table_name']
        return None

    def created_formatted(self):
        if self.created:
            return self.created.strftime('%d %B %Y')

    def as_json(self):
        created = None
        if self.created:
            created = time.mktime(self.created.timetuple())

        return {
            'id_attribute' : self.id_attribute, 
            'name' : self.name,
            'is_string' : self.is_string,
            'is_integer': self.is_integer,
            'is_real' : self.is_real,
            'is_bool' : self.is_bool,
            'is_lexicon' : self.is_lexicon,
            'is_url' : self.is_url,
            'is_picture' : self.is_picture,
            'lexicon_klass' : self.lexicon_klass,
            'enabled' : self.enabled,
            'reference' : self.reference,
            'created' : created,
            'author' : self.author
        }

    def is_updated(self, data):
        """ Checks if object data compared with remote json data is modified
        """
        try:
            if self.id_attribute != data['id_attribute']:
                return True
            if self.name != data['name']:
                return True
            if self.is_string != data['is_string']:
                return True
            if self.is_integer != data['is_integer']:
                return True
            if self.is_real != data['is_real']:
                return True
            if self.is_bool != data['is_bool']:
                return True
            if self.is_lexicon != data['is_lexicon']:
                return True
            if self.is_url != data['is_url']:
                return True
            if self.is_picture != data['is_picture']:
                return True
            if self.lexicon_klass != data['lexicon_klass']:
                return True
            if self.enabled != data['enabled']:
                return True
            if self.reference != data['reference']:
                return True
            if self.created != datetime.fromtimestamp(float(data['created'])):
                return True
            if self.author != data['author']:
                return True
        except:
            return True
        return False

mapper(CatAttribute, t_cat_attribute)



t_cat_catalog = Table('t_cat_catalog', metadata, 
        Column('id_catalog', String, primary_key=True),
        Column('name', String),
        Column('enabled', Boolean),
        Column('reference', Boolean),
        Column('created', TIMESTAMP),
        Column('author', String)
)

class CatCatalog(object):
    """
    Mapping for catalogs table (t_cat_catalog)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def created_formatted(self):
        if self.created:
            return self.created.strftime('%d %B %Y')


    def as_json(self):
        created = None
        if self.created:
            created = time.mktime(self.created.timetuple())

        return {
            'id_catalog' : self.id_catalog,
            'name' : self.name,
            'enabled' : self.enabled,
            'reference' : self.reference,
            'created' : created,
            'author' : self.author
        }


    def is_updated(self, data):
        """ Checks if object data compared with remote json data is modified
        """
        try:
            if self.id_catalog != data['id_catalog']:
                return True
            if self.name != data['name']:
                return True
            if self.enabled != data['enabled']:
                return True
            if self.reference != data['reference']:
                return True
            if self.created != datetime.fromtimestamp(float(data['created'])):
                return True
            if self.author != data['author']:
                return True
        except:
            return True
        return False


mapper(CatCatalog, t_cat_catalog)



t_cat_catalog_dd = Table('t_cat_catalog_dd', metadata, 
        Column('id_catalog', String, ForeignKey(CatCatalog.id_catalog), primary_key=True),
        Column('id_attribute', String, ForeignKey(CatAttribute.id_attribute), primary_key=True),
        Column('show_in_overview', Boolean)
)

class CatCatalogDD(object):
    """
    Mapping for catalogs data definition table (t_cat_catalog_dd)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def as_json(self):
        return {
            'id_catalog' : self.id_catalog,
            'id_attribute' : self.id_attribute,
            'show_in_overview' : self.show_in_overview
        }

mapper(CatCatalogDD, t_cat_catalog_dd)


t_cat_item = Table('t_cat_item', metadata, 
        Column('id_item', String, primary_key=True),
        Column('id_catalog', String, ForeignKey(CatCatalog.id_catalog)),
        Column('brand', String),
        Column('model', String),
        Column('created', TIMESTAMP),
        Column('author', String)
)


class CatItem(object):
    """
    Mapping for catalog item table (t_cat_item)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def as_json(self):
        created = None
        if self.created:
            created = time.mktime(self.created.timetuple())

        return {
            'id_item' : self.id_item,
            'id_catalog' : self.id_catalog,
            'brand' : self.brand,
            'model' : self.model,
            'created' : created,
            'author' : self.author
        }


    def is_updated(self, data):
        """ Checks if object data compared with remote json data is modified
        """
        try:
            if self.id_item != data['id_item']:
                return True
            if self.id_catalog != data['id_catalog']:
                return True
            if self.brand != data['brand']:
                return True
            if self.model != data['model']:
                return True
            if self.created != datetime.fromtimestamp(float(data['created'])):
                return True
            if self.author != data['author']:
                return True
        except:
            return True
        return False

mapper(CatItem, t_cat_item, properties = {
    'catalog_ob': relation(CatCatalog, lazy = True),
})



t_cat_catalog_data = Table('t_cat_catalog_data', metadata, 
        Column('id_item', String, ForeignKey(CatItem.id_item), primary_key=True),
        Column('id_attribute', String, ForeignKey(CatAttribute.id_attribute), primary_key=True),
        Column('value_string', String),
        Column('value_real', Float),
        Column('value_integer', Integer),
        Column('value_bool', Boolean),
        Column('value_lexicon', String)
)


class CatCatalogData(object):
    """
    Mapping for catalog data table (t_cat_catalog_data)
    """
    def __init__(self, **kwargs):
        for k, v in kwargs.iteritems():
            setattr(self, k, v)

    def get_value(self, session):
        if self.attribute_ob:
            if self.attribute_ob.is_string or self.attribute_ob.is_url or self.attribute_ob.is_picture:
                return self.value_string 
            if self.attribute_ob.is_integer:
                return self.value_integer
            if self.attribute_ob.is_real:
                return self.value_real
            if self.attribute_ob.is_bool:
                return self.value_bool
            if self.attribute_ob.is_lexicon:
                lex_row = get_lexicon_row_by_classname(session, self.attribute_ob.lexicon_klass, self.value_lexicon)
                if lex_row:
                    return lex_row.name

    def is_valid(self):
        return self.value_string or self.value_real or self.value_integer or self.value_lexicon or (self.value_bool is not None)

    def as_json(self):
        return {
            'id_item' : self.id_item,
            'id_attribute' : self.id_attribute,
            'value_string' : self.value_string,
            'value_real' : self.value_real,
            'value_integer' : self.value_integer,
            'value_bool' : self.value_bool,
            'value_lexicon' : self.value_lexicon
        }


mapper(CatCatalogData, t_cat_catalog_data, properties = {
        'attribute_ob': relation(CatAttribute, lazy = False),
        'item_ob': relation(CatItem, lazy = True),
    }
)
