'''
Created on May 13, 2010

@author: cristiroma
'''
from z3c.sqlalchemy.util import createSAWrapper
from formencode.schema import SimpleFormValidator

def validate_portal_configuration(value_dict, state, validator):
    error = {}

    db_host = value_dict.get('db_host', None)
    db_name = value_dict.get('db_name', None)
    db_username = value_dict.get('db_username', None)
    db_password = value_dict.get('db_password') or state.db_password
    db_password2 = value_dict.get('db_password2') or state.db_password

    #skin = value_dict.get('skin', state.skin)
    #if not skin or (skin != 'theme1' and skin != 'theme2' and skin != 'theme3'):
    #    error['skin'] = 'Invalid value for skin'

    #moderation = value_dict.get('moderation', state.moderation)
    #if not moderation or (moderation != '1' and moderation != '0'):
    #    error['moderation'] = 'Invalid value for moderation'

    mapserver_url = value_dict.get('mapserver_url', state.mapserver_url)
    if not mapserver_url:
        error ['mapserver_url'] = 'Please enter Mapserver URL'
    
    gmap_key = value_dict.get('gmap_key', state.gmap_key)
    if not gmap_key:
        error ['gmap_key'] = 'Please enter Google Maps API key'

    gis_path = value_dict.get('gis_path', state.gis_path)
    if not gis_path:
        error ['gis_path'] = 'Please enter path to GIS data files'

    if not db_host:
        error ['db_host'] = 'Please enter database host'
    if not db_name:
        error ['db_name'] = 'Please enter database name'
    if not db_username:
        error ['db_username'] = 'Please enter database username'

    if db_password and db_password2 and db_password != db_password2:
        error ['db_password2'] = 'Database passwords do not match'

    try:
        wrapper = createSAWrapper('postgresql://%s:%s@%s/%s' % (db_username, db_password, db_host, db_name), engine_options = {'echo' : True, 'encoding' : 'utf-8'})
        conn = wrapper.session.connection()
        conn.execute('SELECT 1=1')
        conn.close()
    except Exception, e:
        error ['db_invalid'] = 'Invalid database connection. Please check database parameters (%s)' % e

    return error


def update_portal_configuration(portal_ob, REQUEST):

    ValidateConfiguration = SimpleFormValidator(validate_portal_configuration)
    value_dict = ValidateConfiguration.to_python(REQUEST.form, portal_ob)

    if value_dict.has_key('debug') and not portal_ob.debug:
        portal_ob.debug = True
        portal_ob._delete_wrapper()
    if not value_dict.has_key('debug') and portal_ob.debug:
        portal_ob.debug = False
        portal_ob._delete_wrapper()

    portal_ob.db_host = value_dict['db_host']
    portal_ob.db_name = value_dict['db_name']

    if portal_ob.db_username != value_dict['db_username'] or \
            portal_ob.db_password != value_dict['db_password'] or \
            portal_ob.db_host != value_dict['db_host'] or \
            portal_ob.db_name != value_dict['db_name']:
        portal_ob._delete_wrapper()

    portal_ob.db_username = value_dict['db_username']
    if value_dict['db_password']:
        portal_ob.db_password = value_dict['db_password']

    #portal_ob.skin = value_dict['skin']
    portal_ob.moderation = int(value_dict['moderation'])
    portal_ob.gis_path = value_dict['gis_path']
    portal_ob.mapserver_url = value_dict['mapserver_url']
    portal_ob.gmap_key = value_dict['gmap_key']
    
    portal_ob._p_changed = 1



def validate_website_configuration(value_dict, state, validator):
    error = {}

    db_host = value_dict.get('db_host', None)
    db_name = value_dict.get('db_name', None)
    db_super_username = value_dict.get('db_super_username', None)
    db_super_password = value_dict.get('db_super_password') or state.db_super_password
    db_super_password2 = value_dict.get('db_super_password2') or state.db_super_password
    db_username = value_dict.get('db_username', None)
    db_password = value_dict.get('db_password') or state.db_password
    db_password2 = value_dict.get('db_password2') or state.db_password

    gmap_key = value_dict.get('gmap_key', state.gmap_key)
    if not gmap_key:
        error ['gmap_key'] = 'Please enter Google Maps API key'

    if not db_host:
        error ['db_host'] = 'Please enter database host'
    if not db_name:
        error ['db_name'] = 'Please enter database name'
    if not db_username:
        error ['db_username'] = 'Please enter database username'

    if db_password and db_password2 and db_password != db_password2:
        error ['db_password2'] = 'Database passwords do not match'

    if not db_super_username:
        error ['db_super_username'] = 'Please enter database administrator username'

    if db_super_password and db_super_password2 and db_super_password != db_super_password2:
        error ['db_super_password2'] = 'Database passwords do not match'


    try:
        wrapper = createSAWrapper('postgresql://%s:%s@%s/%s' % (db_super_username, db_super_password, db_host, db_name), engine_options = {'echo' : True, 'encoding' : 'utf-8'})
        conn = wrapper.session.connection()
        conn.execute('SELECT 1=1')
        conn.close()
    except Exception, e:
        error ['db_super_invalid'] = 'Invalid database connection to master database. Please check database parameters (%s)' % e

    try:
        wrapper = createSAWrapper('postgresql://%s:%s@%s/%s' % (db_username, db_password, db_host, 'wwebsite'), engine_options = {'echo' : True, 'encoding' : 'utf-8'})
        conn = wrapper.session.connection()
        conn.execute('SELECT 1=1')
        conn.close()
    except Exception, e:
        error ['db_invalid'] = 'Invalid database connection to master database. Please check database parameters (%s)' % e

    return error


def update_website_configuration(portal_ob, REQUEST):

    ValidateConfiguration = SimpleFormValidator(validate_website_configuration)
    value_dict = ValidateConfiguration.to_python(REQUEST.form, portal_ob)

    if portal_ob.db_username != value_dict['db_username'] or  \
            portal_ob.db_password != value_dict['db_password'] or \
            portal_ob.db_host != value_dict['db_host'] or \
            portal_ob.db_name != value_dict['db_name']:
        portal_ob._delete_wrapper()

    portal_ob.db_host = value_dict['db_host']
    portal_ob.db_name = value_dict['db_name']
    
    portal_ob.db_username = value_dict['db_username']
    if value_dict['db_password']:
        portal_ob.db_password = value_dict['db_password']


    portal_ob.db_super_username = value_dict['db_super_username']
    if value_dict['db_super_password']:
        portal_ob.db_super_password = value_dict['db_super_password']


    portal_ob.gmap_key = value_dict['gmap_key']
    portal_ob._p_changed = 1
