# WatSan Platform - Rapid development of national water and sanitation portals
# Copyright (C) 2010  Water and Sanitation Program (http://www.wsp.org)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author(s):
# Cristian Romanescu, Eau De Web
# 
# Define application-specific exceptions



class ValidationException(Exception):
    """
        Exception raised when an validation is not passed.
    """
    def __init__(self, invalid_fields=None, message=None):
        """
        Constructor
        Parameters:
            `fields`
                An array of one or more fields that didn't pass the validation
        """
        self.invalid_fields = invalid_fields
        self.message = message
        Exception.__init__(self, 'Invalid fields during validation: %s' % repr(invalid_fields))



class DatabaseException(Exception):
    """
        Exception raised when an database operational error occurrs.
    """
    pass


class NotImplementedException(Exception):
    """
        Exception raised when functionality is not present.
    """
    pass