'''
Created on Jul 20, 2010

@author: cristiroma
'''

import formencode

#Zope imports
from AccessControl.SecurityInfo import ClassSecurityInfo
from AccessControl.Permissions import view
from Products.WSPortal import constants
from Globals import InitializeClass

#Naaya imports
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile
from Products.Naaya.NyFolder import NyFolder
from ws.common.sql.queries import Catalogs as cat_queries
from ws.common.sql.mappings.Lexicon import lexicon_list
from ws.common.sql.query import get_lexicon_objects_by_classname
from ws.common.sql.mappings.Catalogs import CatCatalog, CatAttribute
from ws.common.sync.CatalogSync import CatalogSync


def create_catalogs_object_callback(parent, id, contributor):
    ob = Catalogs(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.loadDefaultData()
    ob.after_setObject()
    return ob


def validate_add_attribute(values, state, validator):
    ret = {}

    name = values.get('name', '').strip()
    if not name:
        ret['name'] = 'You must fill in an attribute name'

    session = state
    try:
        session.query(CatAttribute).filter_by(name=name).one()
    except:
        pass
    else:
        ret['name'] = 'An attribute with the same name already exists'

    type = values.get('type', '').strip()
    if not type in ['string', 'integer', 'real', 'bool', 'lexicon']:
        ret['type'] = 'Please select an attribute type'

    lexicon = values.get('lexicon', '').strip()
    if type == 'lexicon' and not lexicon in lexicon_list.keys():
        ret['lexicon'] = 'Please select a dictionary'
    return ret


def validate_add_catalog(values, state, validator):
    ret = {}
    name = values.get('name', '').strip()
    if not name:
        ret['name'] = 'You must fill in a catalogue name'

    session = state
    try:
        session.query(CatCatalog).filter_by(name=name).one()
    except:
        pass
    else:
        ret['name'] = 'A catalogue with the same name already exists'

    attributes = values.get('selected_attribute', [])
    clean_attributes = []
    for attr in attributes:
        if attr.strip():
            clean_attributes.append(attr)
    if not clean_attributes:
        ret['attribute'] = 'You must add at least one attribute to the catalogue'

    return ret


def validate_add_product(values, state, validator):
    ret = {}
    brand = values.get('brand', '').strip()
    if not brand:
        ret['brand'] = 'You must fill in a product brand'

    model = values.get('model', '').strip()
    if not model:
        ret['model'] = 'You must fill in a product model'

    valid_catalog = False
    catalog = values.get('catalog', '').strip()
    session = state
    try:
        session.query(CatCatalog).filter_by(id_catalog=catalog).one()
        valid_catalog = True
    except:
        pass
    if not valid_catalog:
        ret['catalog'] = 'Please select a catalogue'

    # Validate data types for attributes
    for key in values.keys():
        objects = session.query(CatAttribute).filter_by(id_attribute=key).all()
        if objects:
            attribute = objects[0]
            user_value = values.get(key)

            if attribute.is_integer:
                if user_value:
                    try:
                        int(user_value)
                    except:
                        ret[key] = 'Please insert an integer value'
            if attribute.is_real:
                if user_value:
                    try:
                        float(user_value)
                    except:
                        ret[key] = 'Please insert a float value'
            if attribute.is_bool:
                if user_value:
                    try:
                        bool(user_value)
                    except:
                        ret[key] = 'Please insert a boolean value'
            if attribute.is_lexicon:
                if user_value:
                    if attribute.lexicon_klass in lexicon_list:
                        klass = lexicon_list[attribute.lexicon_klass]['table_class']
                        lex_objects = session.query(klass).filter_by(code=user_value).all()
                        if len(lex_objects) != 1:
                            ret[key] = 'Invalid value for this dictionary. Synced with website?'
                    else:
                        ret[key] = 'Dictionary for this attribute (%s/%s) does not exists' % (attribute.id_attribute, attribute.name)

            if attribute.is_url:
                if user_value:
                    try:
                        valid = user_value[0 : 7] == 'http://'
                    except:
                        valid = False
                    if not valid:
                        ret[key] = 'Invalid URL. Must start with http://'

            #if attribute.is_picture: - Nothing to validate here

    return ret


class Catalogs(NyFolder):
    security = ClassSecurityInfo()

    def loadDefaultData(self, *args, **kwargs):
        # Add left portlets
        site = self.getSite()
        site_base_url = site.absolute_url(1)
        location = self.absolute_url(1)
        if site_base_url and location.startswith(site_base_url):
            location = location[len(site_base_url)+1:]

        portlets_tool = site.getPortletsTool()
        portlets_tool.assign_portlet(location, position='left', portlet_id='catalogs_search', inherit=True)

    def get_lexicon_rows(self, lex_class_name):
        """ Get content of an dictionary
        """
        session = self.get_db_session()
        return get_lexicon_objects_by_classname(session, lex_class_name)

    # PUBLIC VIEWS
    _index_html = NaayaPageTemplateFile('zpt/index', globals(), 'ws_catalogs_index')
    security.declarePublic('index_html')
    def index_html(self, REQUEST):
        """ Catalogs index page """
        session = self.get_db_session()
        catalogs = cat_queries.list_catalogs(session)
        return self._index_html(REQUEST, catalogs=catalogs)

    _search = NaayaPageTemplateFile('zpt/search', globals(), 'ws_catalogs_search')
    security.declarePublic('search')
    def search(self, REQUEST):
        """ Search for catalogue products """
        results = []
        if REQUEST.form.has_key('btn-search'):
            session = self.get_db_session()
            term = REQUEST.get('term', '')
            results = cat_queries.product_search(session, term)
        return self._search(REQUEST, results=results)

    _view_catalog = NaayaPageTemplateFile('zpt/view_catalog', globals(), 'ws_catalogs_view')
    security.declarePublic('view_catalog')
    def view_catalog(self, id, REQUEST):
        """ View products from a catalog  """
        session = self.get_db_session()
        page = int(REQUEST.get('page', 1))
        sort = REQUEST.get('sort', 'brand')
        order = REQUEST.get('order', 0)
        catalog_data = cat_queries.get_catalog_view_data(session, id, page, sort, order)
        return self._view_catalog(REQUEST, catalog_data=catalog_data)

    _view_product = NaayaPageTemplateFile('zpt/view_product', globals(), 'ws_catalogs_view_product')
    security.declarePublic('view_product')
    def view_product(self, id, REQUEST):
        """ View details about an item from catalog
        """
        session = self.get_db_session()
        item_data = cat_queries.get_product_data(session, id)
        return self._view_product(REQUEST, item_data=item_data)

    #ADMINISTRATION AREA
    _admin = NaayaPageTemplateFile('zpt/admin/index', globals(), 'ws_catalogs_admin')
    security.declareProtected(constants.EDIT_DATA, 'admin')
    def admin(self, REQUEST):
        """ Catalogs administration index page """
        session = self.get_db_session()
        return self._admin(REQUEST)


    _browse = NaayaPageTemplateFile('zpt/admin/browse', globals(), 'ws_catalogs_admin_browse')
    security.declareProtected(constants.EDIT_DATA, 'browse')
    def browse(self, REQUEST):
        """ View list of catalogs  """
        session = self.get_db_session()

        if REQUEST.form.has_key('btn-enable-catalog'):
            ids = REQUEST.get('enable', [])
            cat_queries.enable_catalogs(session, ids)

        if REQUEST.form.has_key('btn-disable-catalog'):
            ids = REQUEST.get('disable', [])
            cat_queries.enable_catalogs(session, ids, False)

        catalogs = cat_queries.list_catalogs(session)
        disabled = cat_queries.list_disabled_catalogs(session)
        return self._browse(REQUEST, catalogs=catalogs, disabled=disabled)


    _add = NaayaPageTemplateFile('zpt/admin/add_catalog', globals(), 'ws_catalogs_admin_add_catalog')
    security.declareProtected(constants.EDIT_DATA, 'add')
    def add(self, REQUEST):
        """ Add new catalog  """
        session = self.get_db_session()
        errors = {'value' : {}, 'error_dict' : {}}
        attributes_ids = REQUEST.get('selected_attribute', [])
        overview_attribute = REQUEST.get('overview_attribute', [])

        if REQUEST.form.has_key('btn-add-attribute'):
            attribute_id = REQUEST.get('attribute')
            attributes_ids.append(attribute_id)
            show_in_overview = REQUEST.get('show_in_overview')
            if show_in_overview:
                overview_attribute.append(attribute_id)

        if REQUEST.form.has_key('btn-remove-attribute'):
            remove_ids = REQUEST.get('remove', [])
            attributes_ids = filter(lambda x : x and x not in remove_ids, attributes_ids)

        if REQUEST.form.has_key('btn-add-catalog'):
            try:
                validator = formencode.schema.SimpleFormValidator(validate_add_catalog)
                form = validator.to_python(REQUEST.form, state=session)
            except formencode.validators.Invalid, e:
                errors = e
            else:
                form['author'] = REQUEST.AUTHENTICATED_USER.name
                cat_queries.add_catalog(session, form, not self.is_portal())
                REQUEST.RESPONSE.redirect('%s/browse' % self.absolute_url())

        catalog_name = REQUEST.get('name', '')
        all_attributes = cat_queries.list_attributes(session)
        selected_attributes = filter(lambda (attr): str(attr.id_attribute) in attributes_ids, all_attributes)
        dropdown_attributes = filter(lambda (attr): not attr in selected_attributes, all_attributes)


        return self._add(REQUEST, all_attributes=dropdown_attributes, 
                                       attributes=selected_attributes,
                                       overview_attribute=overview_attribute, 
                                       errors=errors, catalog_name=catalog_name)


    _products = NaayaPageTemplateFile('zpt/admin/products', globals(), 'ws_catalogs_admin_products')
    security.declareProtected(constants.EDIT_DATA, 'products')
    def products(self, id, REQUEST):
        """ View products from a catalog  """
        session = self.get_db_session()
        page = int(REQUEST.get('page', 1))
        sort = REQUEST.get('sort', 'brand')
        order = REQUEST.get('order', 0)
        catalog_data = cat_queries.get_catalog_view_data(session, id, page, sort, order)
        return self._products(REQUEST, catalog_data=catalog_data)

    _product = NaayaPageTemplateFile('zpt/admin/product', globals(), 'ws_catalogs_admin_product')
    security.declareProtected(constants.EDIT_DATA, 'product')
    def product(self, id, REQUEST):
        """ View details about an item from catalog  """
        session = self.get_db_session()
        item_data = cat_queries.get_product_data(session, id)
        return self._product(REQUEST, item_data=item_data)

    _synchronise = NaayaPageTemplateFile('zpt/admin/synchronise', globals(), 'ws_catalogs_admin_synchronise')
    security.declareProtected(constants.EDIT_DATA, 'synchronise')
    def synchronise(self, REQUEST):
        """ Synchronize catalogs with WatSan website  """
        sync = False; sync_success = False; report = None
        #default_url = '%s/catalogs_sync?format=json' % self.watsan_website_url #@todo: fix this
        default_url = 'http://cristi.edw.ro/wwebsite/catalogs_sync?format=json'
        url_catalog_sync = REQUEST.get('url_catalog_sync', default_url)

        if REQUEST.form.has_key('btn-sync'):
            sync = True
            dc = CatalogSync(self.get_db_session(), url_catalog_sync)
            sync_success = dc.sync_catalogs()
            report = dc.report

        return self._synchronise(REQUEST, sync=sync, report=report, 
                    sync_success = sync_success, url_catalog_sync=url_catalog_sync)


    _attributes = NaayaPageTemplateFile('zpt/admin/attributes', globals(), 'ws_catalogs_admin_attributes')
    security.declareProtected(constants.EDIT_DATA, 'attributes')
    def attributes(self, REQUEST):
        """ View list of attributes """
        session = self.get_db_session()
        attributes = cat_queries.list_attributes(session)
        disabled = cat_queries.list_disabled_attributes(session)
        return self._attributes(REQUEST, attributes=attributes, disabled=disabled)


    _add_attribute = NaayaPageTemplateFile('zpt/admin/add_attribute', globals(), 'ws_catalogs_admin_add_attribute')
    security.declareProtected(constants.EDIT_DATA, 'add_attribute')
    def add_attribute(self, REQUEST):
        """ Add new attributes """
        session = self.get_db_session()
        errors = {'value' : {}, 'error_dict' : {}}

        if REQUEST.form.has_key('btn-add-attribute'):
            try:
                validator = formencode.schema.SimpleFormValidator(validate_add_attribute)
                form = validator.to_python(REQUEST.form, state=session)
            except formencode.validators.Invalid, e:
                errors = e
            else:
                form['author'] = REQUEST.AUTHENTICATED_USER.name
                cat_queries.add_attribute(session, form, not self.is_portal())

        if REQUEST.form.has_key('btn-enable-attribute'):
            ids = REQUEST.get('enable', [])
            cat_queries.enable_attributes(session, ids)

        if REQUEST.form.has_key('btn-disable-attribute'):
            ids = REQUEST.get('disable', [])
            cat_queries.enable_attributes(session, ids, False)

        attributes = cat_queries.list_attributes(session)

        lex_descriptions = []
        lex_dict = {}

        for key in lexicon_list.keys():
            lex_descriptions.append(lexicon_list[key]['table_name'])
            lex_dict[lexicon_list[key]['table_name']] = key
        lex_descriptions.sort()

        disabled = cat_queries.list_disabled_attributes(session)
        return self._add_attribute(REQUEST, attributes=attributes, lex_descriptions=lex_descriptions, lex_dict=lex_dict, errors=errors, disabled=disabled)


    _add_product = NaayaPageTemplateFile('zpt/admin/add_product', globals(), 'ws_catalogs_admin_add_product')
    security.declareProtected(constants.EDIT_DATA, 'add_product')
    def add_product(self, REQUEST):
        """ View details about an item from catalog """
        errors = {'value' : {}, 'error_dict' : {}}
        session = self.get_db_session()
        catalogs = cat_queries.list_editable_catalogs(session, self.is_portal())
        id = REQUEST.get('catalog', None)

        if not id:
            return self._add_product(REQUEST, catalogs = catalogs)
        attributes = cat_queries.get_catalog_attributes(session, id)
        catalog_data = cat_queries.get_catalog_view_data(session,
                                                         id_catalog = id,
                                                         page = int(REQUEST.get('page', 1)),
                                                         sort = REQUEST.get('sort', 'brand'),
                                                         order = REQUEST.get('order', 0))

        if REQUEST.form.has_key('btn-add-product'):
            try:
                validator = formencode.schema.SimpleFormValidator(validate_add_product)
                form = validator.to_python(REQUEST.form, state=session)
            except formencode.validators.Invalid, e:
                errors = e
            else:
                catalog = cat_queries.get_catalog(session, id)
                # In portal we cannot modify reference catalogs
                if (self.is_portal() and not catalog.reference) or not self.is_portal():
                    gallery = self.get_photos_gallery().technical_catalogs
                    form['author'] = REQUEST.AUTHENTICATED_USER.name
                    cat_queries.add_product(session, form, gallery, not self.is_portal())
                else:
                    errors['error_dict']['catalog'] = 'You cannot modify reference catalogues'

        return self._add_product(REQUEST,
                                 catalogs = catalogs,
                                 attributes = attributes,
                                 catalog_data = catalog_data,
                                 errors = errors)

InitializeClass(Catalogs)