/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class GtopoIosp
extends AbstractIOServiceProvider {
    private int nlats = 6000;
    private int nlons = 4800;
    private float incr = 0.008333334f;
    private float startx;
    private float starty;
    private RandomAccessFile raf;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        String location = raf.getLocation();
        if (!location.endsWith(".DEM")) {
            return false;
        }
        int pos = location.lastIndexOf(".");
        String stub = location.substring(0, pos);
        File hdrFile = new File(stub + ".HDR");
        return hdrFile.exists();
    }

    public String getFileTypeId() {
        return "GTOPO";
    }

    public String getFileTypeDescription() {
        return "USGS GTOPO digital elevation model";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.readHDR();
        ncfile.addDimension(null, new Dimension("lat", this.nlats));
        ncfile.addDimension(null, new Dimension("lon", this.nlons));
        Variable elev = new Variable(ncfile, null, null, "elevation");
        elev.setDataType(DataType.SHORT);
        elev.setDimensions("lat lon");
        elev.addAttribute(new Attribute("units", "m"));
        elev.addAttribute(new Attribute("units_desc", "meters above sea level"));
        elev.addAttribute(new Attribute("long_name", "digital elevation in meters above mean sea level"));
        elev.addAttribute(new Attribute("missing_value", (short)-9999));
        ncfile.addVariable(null, elev);
        Variable lat = new Variable(ncfile, null, null, "lat");
        lat.setDataType(DataType.FLOAT);
        lat.setDimensions("lat");
        lat.addAttribute(new Attribute("units", "degrees_north"));
        ncfile.addVariable(null, lat);
        Array data = Array.makeArray(DataType.FLOAT, this.nlats, this.starty, -this.incr);
        lat.setCachedData(data, false);
        Variable lon = new Variable(ncfile, null, null, "lon");
        lon.setDataType(DataType.FLOAT);
        lon.setDimensions("lon");
        lon.addAttribute(new Attribute("units", "degrees_east"));
        ncfile.addVariable(null, lon);
        Array lonData = Array.makeArray(DataType.FLOAT, this.nlons, this.startx, this.incr);
        lon.setCachedData(lonData, false);
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        ncfile.addAttribute(null, new Attribute("History", "Direct read by Netcdf-Java CDM library"));
        ncfile.addAttribute(null, new Attribute("Source", "http://eros.usgs.gov/products/elevation/gtopo30.html"));
        ncfile.finish();
    }

    private void readHDR() throws IOException {
        String location = this.raf.getLocation();
        int pos = location.lastIndexOf(".");
        String HDRname = location.substring(0, pos) + ".HDR";
        String HDRcontents = IO.readFile(HDRname);
        StringTokenizer stoke = new StringTokenizer(HDRcontents);
        while (stoke.hasMoreTokens()) {
            String key = stoke.nextToken();
            if (key.equals("ULXMAP")) {
                this.startx = Float.parseFloat(stoke.nextToken());
                continue;
            }
            if (key.equals("ULYMAP")) {
                this.starty = Float.parseFloat(stoke.nextToken());
                continue;
            }
            stoke.nextToken();
        }
    }

    public Array readData(Variable v2, Section wantSection) throws IOException, InvalidRangeException {
        this.raf.order(0);
        int size = (int)wantSection.computeSize();
        short[] arr = new short[size];
        LayoutRegular indexer = new LayoutRegular(0L, v2.getElementSize(), v2.getShape(), wantSection);
        while (indexer.hasNext()) {
            Layout.Chunk chunk = indexer.next();
            this.raf.seek(chunk.getSrcPos());
            this.raf.readShort(arr, (int)chunk.getDestElem(), chunk.getNelems());
        }
        return Array.factory(v2.getDataType().getPrimitiveClassType(), wantSection.getShape(), (Object)arr);
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

