import logging
import transaction
from App.ImageFile import ImageFile
from OFS import Folder

import NaayaUpdater
from updates import LOGS_FOLDERNAME
import NaayaPatches

UpdaterID = NaayaUpdater.UPDATERID
logger = logging.getLogger('naayaUpdater')

def initialize(context):
    """ """
    #add Naaya Updater
    global updater
    app = context._ProductContext__app

    if hasattr(app, UpdaterID):
        updater = getattr(app, UpdaterID)
    else:
        try:
            updater = NaayaUpdater.NaayaUpdater(id=UpdaterID)
            app._setObject(UpdaterID, updater)
            logger.info('Added Naaya Updater')
            transaction.commit()
        except:
            pass
        updater = getattr(app, UpdaterID)
    assert updater is not None

    if not hasattr(app, LOGS_FOLDERNAME):
        Folder.manage_addFolder(app, LOGS_FOLDERNAME)

misc_ = {
    "updater.jpg":  ImageFile("www/updater.jpg", globals()),
    "updater.js":  ImageFile("www/updater.js", globals()),
}
