from Products.NaayaCore.EmailTool.EmailPageTemplate import EmailPageTemplateFile

from naaya.core.utils import is_valid_email, cleanup_message

from naaya.core.exceptions import i18n_exception
from Products.NaayaCore.NotificationTool.interfaces import ISubscriptionContainer
from Products.NaayaCore.NotificationTool.containers import AnonymousSubscription
from Products.NaayaCore.NotificationTool import NotificationTool, utils as NotificationToolUtils
from Products.NaayaCore.FormsTool.NaayaTemplate import NaayaPageTemplateFile

NotificationTool.email_templates['newsletter_email'] = EmailPageTemplateFile(
                                        'zpt/newsletter_email.zpt', globals())
newsletter_template = NaayaPageTemplateFile('zpt/newsletter', globals(),
                                            'naaya.conference.newsletter_template')

kw = {'notif_type': 'monthly',
      'lang': 'en',
      'location': '/'}

def setNewsletterSession(first_name, last_name, email, organisation, country, SESSION):
    SESSION.set('first_name', first_name)
    SESSION.set('last_name', last_name)
    SESSION.set('email', email)
    SESSION.set('organisation', organisation)
    SESSION.set('country', country)

def newsletter_view(context, REQUEST):
    """ """
    err = []
    site = context.getSite()
    if REQUEST.form.has_key('subscribe'):
        first_name = REQUEST.form.get('first_name', '')
        if first_name.strip() == '':
            err.append('The first name is required')

        last_name = REQUEST.form.get('last_name', '')
        if last_name.strip() == '':
            err.append('The last name is required')

        organisation = REQUEST.form.get('organisation', '')
        if organisation.strip() == '':
            err.append('The organisation is required')

        email = REQUEST.form.get('email', '').strip()
        if email == '':
            err.append('The email is required')
        elif not is_valid_email(email):
            err.append('Your e-mail address does not appear to be valid.')
        else:
            subscriptions = ISubscriptionContainer(context.getSite())
            for existing_subscription in subscriptions:
                if email == existing_subscription.email:
                    err.append('Subscription already exists')

        country = REQUEST.form.get('country', '').strip()

        if err:
            site.setSessionErrorsTrans(err)
            setNewsletterSession(first_name, last_name, email, organisation,
                country, REQUEST.SESSION)
        else:
            emails = [ subscription.email for subscription in subscriptions ]

            kw.update({'first_name': first_name,
                      'last_name': last_name,
                      'email': email,
                      'organisation': organisation,
                      'country': country,})
            subscription = AnonymousSubscription(**kw)
            subscriptions.add(subscription) # Add to subscribed list

            REQUEST.SESSION.set('success', True)

    return newsletter_template.__of__(context)()


newsletter_admin_template = NaayaPageTemplateFile('zpt/newsletter_admin',
                                  globals(), 'naaya.conference.admin_template')

def newsletter_admin(context, REQUEST):
    """ """
    site = context.getSite()
    subscriptions = ISubscriptionContainer(context.getSite())
    emails = [ subscription.email for subscription in subscriptions ]

    if REQUEST.form.has_key('sent'):
        subject = REQUEST.form.get('subject', '')
        message = cleanup_message(REQUEST.form.get('message', ''))

        email_tool = site.getEmailTool()
        addr_from = email_tool.get_addr_from()
 
        template = site.portal_notification._get_template('newsletter_email')
        for subscription in subscriptions:
            mail_data = template(site_url=site.absolute_url(), email=subscription.email, **REQUEST.form)
            NotificationToolUtils.send_notification(email_tool, addr_from, subscription.email, 
                                                    mail_data['subject'], mail_data['body_text'])
        message = 'Newsletter was sent'
    else:
        message = ''
    return newsletter_admin_template.__of__(context)(message=message, subscriptions=len(emails))


unsubscribe_template = NaayaPageTemplateFile('zpt/unsubscribe', globals(), 'naaya.conference.unsubscribe')
def unsubscribe_view(context, REQUEST):
    """ """
    subscription_container = ISubscriptionContainer(context.getSite())
    anonymous_subscriptions = [(n, s) for n, s in
                               subscription_container.list_with_keys()
                               if hasattr(s, 'email')]
    subscriptions = filter(lambda s: (s[1].email == REQUEST.get('email', '')),  anonymous_subscriptions)
    if len(subscriptions) >= 1:
        subscription_container.remove(subscriptions[0][0])
    return unsubscribe_template.__of__(context)()