from Products.PageTemplates.PageTemplateFile import PageTemplateFile

schedule_template = PageTemplateFile('zpt/schedule', globals())

def compute_schedule(site):
    presentations = site.programme.objectValues('Naaya Conference Presentation')
    breaks = site.programme.objectValues('Naaya Conference Break')
    slots = site.programme.objectValues('Naaya Conference Slot')
    #tracks = site.programme.objectValues('Naaya Conference Track')

    presentation_for_slot = {}
    for pres in presentations:
        presentation_for_slot[pres.slot] = pres

    breaks_for_slot = {}
    for brk in breaks:
        breaks_for_slot[brk.slot] = brk

    days = {}
    day_tracks = {}
    for slot in slots:
        date = slot.start_date.ISO()[:10]
        hour = slot.start_date.ISO()[11:16]
        if date not in days:
            days[date] = {}
        if date not in day_tracks:
            day_tracks[date] = []
        if hour not in days[date]:
            days[date][hour] = []

        days[date][hour].append(slot)
        track = slot.getTrack()
        if track not in day_tracks[date]:
            if track is not None:
                day_tracks[date].append(track)

    def slot_content(slot):
        if slot is not None:
            slot_id = slot.getId()
            presentation = presentation_for_slot.get(slot_id)
            if presentation is not None:
                return presentation
            break_ = breaks_for_slot.get(slot_id)
            if break_ is not None:
                return break_

    output = []
    for day in days:
        day_table = []
        for hour in sorted(days[day]):
            per_track = {}
            plenary = None
            for slot in sorted(days[day][hour]):
                if not slot.track:
                    plenary = slot
                else:
                    per_track[slot.track] = slot

            if plenary is not None:
                day_table.append({'hour': hour, 'plenary': slot_content(plenary)})
            else:
                hour_row = [slot_content(per_track.get(track.getId())) for track in day_tracks[day]]
                day_table.append({'hour': hour, 'contents': hour_row})

        output.append({'day': day, 'hours': day_table, 'tracks': day_tracks[day]})

    return output

def schedule_view(context, REQUEST):
    return schedule_template.__of__(context)(days=compute_schedule(context.getSite()))
