import os
import sys

from Globals import InitializeClass
from App.ImageFile import ImageFile
from AccessControl import ClassSecurityInfo
from AccessControl.Permissions import view_management_screens, view
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Acquisition import Implicit
from zope.interface import implements
from zope.event import notify
from naaya.content.base.events import NyContentObjectAddEvent
from naaya.content.base.events import NyContentObjectEditEvent

from Products.NaayaBase.NyContentType import NyContentType
from naaya.content.base.constants import *
from Products.NaayaBase.constants import *
from Products.NaayaBase.NyItem import NyItem
from Products.NaayaBase.NyAttributes import NyAttributes
from Products.NaayaBase.NyContentType import NyContentData
from Products.NaayaCore.managers.utils import slugify, uniqueId
from naaya.core import submitter
from naaya.core.zope2util import abort_transaction_keep_session

from interfaces import INyConferenceBreak
from permissions import PERMISSION_ADD_BREAK

DEFAULT_SCHEMA = {
    'title':        dict(sortorder=100, widget_type='String', label='Name', localized=True, required=True),
    'description':  dict(sortorder=110, widget_type='TextArea', label='Description (HTML)', localized=True, tinymce=True),
    'slot':         dict(sortorder=120, widget_type='ConferenceSelect', label='Slot', list_id='programme:Naaya Conference Slot')
}

# this dictionary is updated at the end of the module
config = {
        'product': 'NaayaContent',
        'module': 'break',
        'package_path': os.path.abspath(os.path.dirname(__file__)),
        'meta_type': 'Naaya Conference Break',
        'label': 'Conference Break',
        'permission': PERMISSION_ADD_BREAK,
        'forms': ['break_add', 'break_edit', 'break_index'],
        'add_form': 'break_add_html',
        'description': 'This is Naaya Conference Break type.',
        'default_schema': DEFAULT_SCHEMA,
        'schema_name': 'NyConferenceBreak',
        '_module': sys.modules[__name__],
        'additional_style': None,
        'icon': os.path.join(os.path.dirname(__file__), 'www', 'break.png'),
        '_misc': {
                'break.png': ImageFile('www/break.png', globals()),
            },
    }

def break_add_html(self, REQUEST=None, RESPONSE=None):
    """ """
    from Products.NaayaBase.NyContentType import get_schema_helper_for_metatype
    form_helper = get_schema_helper_for_metatype(self, config['meta_type'])
    return self.getFormsTool().getContent({
            'here': self,
            'kind': config['meta_type'],
            'action': 'addNyConferenceBreak',
            'form_helper': form_helper,
            'submitter_info_html': submitter.info_html(self, REQUEST),
        },
        'break_add')

def _create_NyConferencebreak_object(parent, id, contributor):
    id = uniqueId(slugify(id or 'break', removelist=[]),
                  lambda x: parent._getOb(x, None) is not None)
    ob = NyConferenceBreak(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

def addNyConferenceBreak(self, id='', REQUEST=None, contributor=None, **kwargs):
    """
    Create an Naaya Conference Break type of object.
    """
    if REQUEST is not None:
        schema_raw_data = dict(REQUEST.form)
    else:
        schema_raw_data = kwargs
    _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))
    schema_raw_data.setdefault('description', '')
    schema_raw_data.setdefault('break', '')

    id = uniqueId(slugify(id or schema_raw_data.get('title', '') or 'break',
                          removelist=[]),
                  lambda x: self._getOb(x, None) is not None)
    if contributor is None: contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()

    ob = _create_NyConferencebreak_object(self, id, contributor)

    form_errors = ob.process_submitted_form(schema_raw_data, _lang)

    if REQUEST is not None:
        submitter_errors = submitter.info_check(self, REQUEST, ob)
        form_errors.update(submitter_errors)

    if form_errors:
        if REQUEST is None:
            raise ValueError(form_errors.popitem()[1]) # pick a random error
        else:
            abort_transaction_keep_session(REQUEST)
            ob._prepare_error_response(REQUEST, form_errors, schema_raw_data)
            REQUEST.RESPONSE.redirect('%s/break_add_html' % self.absolute_url())
            return

    approved, approved_by = 1, self.REQUEST.AUTHENTICATED_USER.getUserName()
    ob.approveThis(approved, approved_by)
    ob.submitThis()

    notify(NyContentObjectAddEvent(ob, contributor, schema_raw_data))
    #log post date
    auth_tool = self.getAuthenticationTool()
    auth_tool.changeLastPost(contributor)
    #redirect if case
    if REQUEST is not None:
        l_referer = REQUEST['HTTP_REFERER'].split('/')[-1]
        if l_referer == 'break_add_html':
            self.setSession('referer', self.absolute_url())
            return ob.object_submitted_message(REQUEST)
            REQUEST.RESPONSE.redirect('%s/messages_html' % self.absolute_url())
        else: # undefined state (different referer, called in other context)
            return ob

    return ob.getId()

class NyConferenceBreak(Implicit, NyContentData, NyAttributes, NyItem, NyContentType):
    """ """

    implements(INyConferenceBreak)

    meta_type = config['meta_type']
    meta_label = config['label']

    def manage_options(self):
        """ """
        l_options = ()
        l_options += ({'label': 'View', 'action': 'index_html'},) + NyItem.manage_options
        return l_options

    security = ClassSecurityInfo()

    def __init__(self, id, contributor):
        """ """
        self.id = id
        NyItem.__dict__['__init__'](self)
        self.contributor = contributor

    def getSlot(self):
        """ get slot object """
        site = self.getSite()
        return getattr(site.programme, self.slot, None)

    def schedule_html(self, colspan=1):
        html = '<td colspan="%d" class="break">' % colspan
        html += self.title
        html += '</td>'
        return html

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'saveProperties')
    def saveProperties(self, REQUEST=None, **kwargs):
        """ """
        if not self.checkPermissionEditObject():
            raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG

        if self.hasVersion():
            obj = self.version
            if self.checkout_user != self.REQUEST.AUTHENTICATED_USER.getUserName():
                raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG
        else:
            obj = self

        if REQUEST is not None:
            schema_raw_data = dict(REQUEST.form)
        else:
            schema_raw_data = kwargs
        _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))

        form_errors = self.process_submitted_form(schema_raw_data, _lang)

        if not form_errors:
            self._p_changed = 1
            #log date
            contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()
            auth_tool = self.getAuthenticationTool()
            auth_tool.changeLastPost(contributor)
            notify(NyContentObjectEditEvent(self, contributor))
            if REQUEST:
                self.setSessionInfoTrans(MESSAGE_SAVEDCHANGES, date=self.utGetTodayDate())
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
        else:
            if REQUEST is not None:
                self._prepare_error_response(REQUEST, form_errors, schema_raw_data)
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
            else:
                raise ValueError(form_errors.popitem()[1]) # pick a random error

    security.declareProtected(view, 'index_html')
    def index_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'break_index')

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'edit_html')
    def edit_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'break_edit')

InitializeClass(NyConferenceBreak)

config.update({
    'constructors': (addNyConferenceBreak,),
    'folder_constructors': [
            ('break_add_html', break_add_html),
            ('addNyConferenceBreak', addNyConferenceBreak),
        ],
    'add_method': addNyConferenceBreak,
    '_class': NyConferenceBreak,
})

def get_config():
    return config
