import os
import sys

from Globals import InitializeClass
from App.ImageFile import ImageFile
from AccessControl import ClassSecurityInfo
from AccessControl.Permissions import view_management_screens, view
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Acquisition import Implicit
from zope.interface import implements
from zope.event import notify
from naaya.content.base.events import NyContentObjectAddEvent
from naaya.content.base.events import NyContentObjectEditEvent

from Products.NaayaBase.NyContentType import NyContentType
from naaya.content.base.constants import *
from Products.NaayaBase.constants import *
from Products.NaayaBase.NyItem import NyItem
from Products.NaayaBase.NyAttributes import NyAttributes
from Products.NaayaBase.NyContentType import NyContentData
from Products.NaayaCore.managers.utils import slugify, uniqueId
from naaya.core import submitter
from naaya.core.zope2util import abort_transaction_keep_session

from interfaces import INyConferencePresentation
from permissions import PERMISSION_ADD_PRESENTATION


DEFAULT_SCHEMA = {
    'title':        dict(sortorder=100, widget_type='String', label='Name', localized=True, required=True),
    'description':  dict(sortorder=110, widget_type='TextArea', label='Description (HTML)', localized=True, tinymce=True),
    'abstract':     dict(sortorder=120, widget_type='TextArea', label='Abstract (HTML)', localized=True, tinymce=True),
    'speakers':     dict(sortorder=130, widget_type='ConferenceMultipleSelect', label='Speakers', list_id='speakers:Naaya Conference Speaker'),
    'slot':         dict(sortorder=140, widget_type='ConferenceSelect', label='Slot', list_id='programme:Naaya Conference Slot')
}

# this dictionary is updated at the end of the module
config = {
        'product': 'NaayaContent',
        'module': 'presentation',
        'package_path': os.path.abspath(os.path.dirname(__file__)),
        'meta_type': 'Naaya Conference Presentation',
        'label': 'Conference Presentation',
        'permission': PERMISSION_ADD_PRESENTATION,
        'forms': ['presentation_add', 'presentation_edit', 'presentation_index'],
        'add_form': 'presentation_add_html',
        'description': 'This is Naaya Conference Presentation type.',
        'default_schema': DEFAULT_SCHEMA,
        'schema_name': 'NyConferencePresentation',
        '_module': sys.modules[__name__],
        'additional_style': None,
        'icon': os.path.join(os.path.dirname(__file__), 'www', 'presentation.png'),
        '_misc': {
                'presentation.png': ImageFile('www/presentation.png', globals()),
            },
    }

def presentation_add_html(self, REQUEST=None, RESPONSE=None):
    """ """
    from Products.NaayaBase.NyContentType import get_schema_helper_for_metatype
    form_helper = get_schema_helper_for_metatype(self, config['meta_type'])
    return self.getFormsTool().getContent({
            'here': self,
            'kind': config['meta_type'],
            'action': 'addNyConferencePresentation',
            'form_helper': form_helper,
            'submitter_info_html': submitter.info_html(self, REQUEST),
        },
        'presentation_add')

def _create_NyConferencePresentation_object(parent, id, contributor):
    id = uniqueId(slugify(id or 'presentation', removelist=[]),
                  lambda x: parent._getOb(x, None) is not None)
    ob = NyConferencePresentation(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

def addNyConferencePresentation(self, id='', REQUEST=None, contributor=None, **kwargs):
    """
    Create an Naaya Conference Presentation type of object.
    """
    if REQUEST is not None:
        schema_raw_data = dict(REQUEST.form)
    else:
        schema_raw_data = kwargs
    _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))
    schema_raw_data.setdefault('description', '')
    schema_raw_data.setdefault('abstract', '')
    schema_raw_data.setdefault('speakers', '')
    schema_raw_data.setdefault('slot', '')

    id = uniqueId(slugify(id or schema_raw_data.get('title', '') or 'presentation',
                          removelist=[]),
                  lambda x: self._getOb(x, None) is not None)
    if contributor is None: contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()

    ob = _create_NyConferencePresentation_object(self, id, contributor)

    form_errors = ob.process_submitted_form(schema_raw_data, _lang)

    if REQUEST is not None:
        submitter_errors = submitter.info_check(self, REQUEST, ob)
        form_errors.update(submitter_errors)

    if form_errors:
        if REQUEST is None:
            raise ValueError(form_errors.popitem()[1]) # pick a random error
        else:
            abort_transaction_keep_session(REQUEST)
            ob._prepare_error_response(REQUEST, form_errors, schema_raw_data)
            REQUEST.RESPONSE.redirect('%s/presentation_add_html' % self.absolute_url())
            return

    approved, approved_by = 1, self.REQUEST.AUTHENTICATED_USER.getUserName()
    ob.approveThis(approved, approved_by)
    ob.submitThis()

    self.recatalogNyObject(ob)
    notify(NyContentObjectAddEvent(ob, contributor, schema_raw_data))
    #log post date
    auth_tool = self.getAuthenticationTool()
    auth_tool.changeLastPost(contributor)
    #redirect if case
    if REQUEST is not None:
        l_referer = REQUEST['HTTP_REFERER'].split('/')[-1]
        if l_referer == 'presentation_add_html':
            self.setSession('referer', self.absolute_url())
            return ob.object_submitted_message(REQUEST)
            REQUEST.RESPONSE.redirect('%s/messages_html' % self.absolute_url())
        else: # undefined state (different referer, called in other context)
            return ob

    return ob.getId()

class NyConferencePresentation(Implicit, NyContentData, NyAttributes, NyItem, NyContentType):
    """ """

    implements(INyConferencePresentation)

    meta_type = config['meta_type']
    meta_label = config['label']

    def manage_options(self):
        """ """
        l_options = ()
        l_options += ({'label': 'View', 'action': 'index_html'},) + NyItem.manage_options
        return l_options

    security = ClassSecurityInfo()

    def __init__(self, id, contributor):
        """ """
        self.id = id
        NyItem.__dict__['__init__'](self)
        self.contributor = contributor

    def getSpeakers(self):
        """ get speaker objects """
        site = self.getSite()
        return [ getattr(site.speakers, speaker, None) for speaker in self.speakers ]

    def getSlot(self):
        """ get slot object """
        site = self.getSite()
        return getattr(site.programme, self.slot, None)

    def schedule_html(self, colspan=1):
        html = '<td colspan="%d" class="presentation">' % colspan
        html += '<div>'
        html += '<a href="%s">%s</a>' % (self.absolute_url(), self.title)
        for speaker in self.getSpeakers():
            html += '<span><a href="%s">%s</a></span>'  % (speaker.absolute_url(), speaker.title)
        html += '</div>'
        html += '</td>'
        return html

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'saveProperties')
    def saveProperties(self, REQUEST=None, **kwargs):
        """ """
        if not self.checkPermissionEditObject():
            raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG

        if self.hasVersion():
            obj = self.version
            if self.checkout_user != self.REQUEST.AUTHENTICATED_USER.getUserName():
                raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG
        else:
            obj = self

        if REQUEST is not None:
            schema_raw_data = dict(REQUEST.form)
        else:
            schema_raw_data = kwargs
        _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))

        form_errors = self.process_submitted_form(schema_raw_data, _lang)

        if not form_errors:
            self._p_changed = 1
            self.recatalogNyObject(self)
            #log date
            contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()
            auth_tool = self.getAuthenticationTool()
            auth_tool.changeLastPost(contributor)
            notify(NyContentObjectEditEvent(self, contributor))
            if REQUEST:
                self.setSessionInfoTrans(MESSAGE_SAVEDCHANGES, date=self.utGetTodayDate())
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
        else:
            if REQUEST is not None:
                self._prepare_error_response(REQUEST, form_errors, schema_raw_data)
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
            else:
                raise ValueError(form_errors.popitem()[1]) # pick a random error

    security.declareProtected(view, 'index_html')
    def index_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'presentation_index')

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'edit_html')
    def edit_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'presentation_edit')

InitializeClass(NyConferencePresentation)

config.update({
    'constructors': (addNyConferencePresentation,),
    'folder_constructors': [
            ('presentation_add_html', presentation_add_html),
            ('addNyConferencePresentation', addNyConferencePresentation),
        ],
    'add_method': addNyConferencePresentation,
    '_class': NyConferencePresentation,
})

def get_config():
    return config
