from Products.PageTemplates.PageTemplateFile import PageTemplateFile

from naaya.core.utils import is_valid_email
from naaya.core.exceptions import i18n_exception
from Products.NaayaCore.NotificationTool.interfaces import ISubscriptionContainer
from Products.NaayaCore.NotificationTool.containers import AnonymousSubscription
from Products.NaayaCore.NotificationTool import NotificationTool, utils as NotificationToolUtils

newsletter_template = PageTemplateFile('zpt/newsletter', globals())

kw = {'notif_type': 'monthly',
      'lang': 'en',
      'location': '/'}

def newsletter_view(context, REQUEST):
    """ """
    kw.update(**REQUEST.form)
    subscriptions = ISubscriptionContainer(context.getSite())

    #check email address
    if not is_valid_email(kw.get('email', '')):
        return newsletter_template.__of__(context)(
                    message='Your e-mail address does not appear to be valid.')

    #check if the email is not already subscribed
    for existing_subscription in subscriptions:
        if kw.get('email', '') == existing_subscription.email:
            return newsletter_template.__of__(context)(
                        message='Subscription already exists')

    subscription = AnonymousSubscription(**kw)
    subscriptions.add(subscription) # Add to subscribed list

    return newsletter_template.__of__(context)(message='')


newsletter_admin_template = PageTemplateFile('zpt/newsletter_admin', globals())

def newsletter_admin(context, REQUEST):
    """ """
    site = context.getSite()
    subscriptions = ISubscriptionContainer(context.getSite())
    emails = [ subscription.email for subscription in subscriptions ]

    if REQUEST.form.has_key('sent'):
        subject = REQUEST.form.get('subject', '')
        message = REQUEST.form.get('message', '')

        email_tool = site.getEmailTool()
        addr_from = email_tool.get_addr_from()
 
        for subscription in subscriptions:
            unsubcribe = """-------------------------------------------------------------------------
            If you want to unsubscribe from this notifications follow the link below:
            %s/unsubscribe_html?email=%s""" % (site.absolute_url(), subscription.email)
            NotificationToolUtils.send_notification(email_tool, addr_from, subscription.email, subject, '%s%s' % (message, unsubcribe))
        message = 'Newsletter was sent'
    else:
        message = ''
    return newsletter_admin_template.__of__(context)(message=message, subscriptions=len(emails))


unsubscribe_template = PageTemplateFile('zpt/unsubscribe', globals())
def unsubscribe_view(context, REQUEST):
    """ """
    subscription_container = ISubscriptionContainer(context.getSite())
    anonymous_subscriptions = [(n, s) for n, s in
                               subscription_container.list_with_keys()
                               if hasattr(s, 'email')]
    subscriptions = filter(lambda s: (s[1].email == REQUEST.get('email', '')),  anonymous_subscriptions)
    if len(subscriptions) >= 1:
        subscription_container.remove(subscriptions[0][0])
    return unsubscribe_template.__of__(context)()