from DateTime import DateTime
from Products.NaayaCore.SchemaTool import Schema
from Products.NaayaCore.SchemaTool.widgets import SelectMultipleWidget, SelectWidget, DateWidget
from Products.PageTemplates.PageTemplateFile import PageTemplateFile

def get_objects(self):
    site = self.getSite()
    folder_name, item_meta_type = self.list_id.split(':')
    folder = site.restrictedTraverse(folder_name)
    listing = folder.objectValues(item_meta_type)
    if listing == []:
        return None
    return listing

class ConferenceMultipleSelectWidget(SelectMultipleWidget.SelectMultipleWidget):
    meta_type = 'Naaya Schema Conference Multiple Select Widget'
    get_selection_list = get_objects

class ConferenceSelectWidget(SelectWidget.SelectWidget):
    meta_type = 'Naaya Schema Conference Select Widget'
    get_selection_list = get_objects

class ConferenceDateWidget(DateWidget.DateWidget):
    meta_type = 'Naaya Schema Conference Date Widget'

    def parseFormData(self, value):
        """Get datamodel from form"""
        # if not value:
        #     return None
        # try:
        #     day, month, year = [int(i) for i in value.strip().split('/')]
        #     value = DateTime(year, month, day)
        # except:
        #     raise WidgetError('Invalid date string for "%s"' % self.title)
        return value

    def _convert_to_form_string(self, value):
        if isinstance(value, DateTime):
            value = value.strftime('%Y.%m.%d %H:%M')
        return value

    template = PageTemplateFile('zpt/widget_conference_date', globals())

def addConferenceMultipleSelectWidget(container, id="", title="Conference Multiple Select Widget", REQUEST=None, **kwargs):
    """ Contructor for Conference Multiple Select widget"""
    return SelectMultipleWidget.manage_addWidget(ConferenceMultipleSelectWidget, container, id, title, REQUEST, **kwargs)

def addConferenceSelectWidget(container, id="", title="Conference Select Widget", REQUEST=None, **kwargs):
    """ Contructor for Conference Select widget"""
    return SelectWidget.manage_addWidget(ConferenceSelectWidget, container, id, title, REQUEST, **kwargs)

def addConferenceDateWidget(container, id="", title="Conference Date Widget", REQUEST=None, **kwargs):
    """ Contructor for Conference Date widget"""
    return DateWidget.manage_addWidget(ConferenceDateWidget, container, id, title, REQUEST, **kwargs)

def register_widgets():
    """ register custom widgets for Conference """
    Schema.widget_constructors['ConferenceMultipleSelect'] = addConferenceMultipleSelectWidget
    Schema.widget_constructors['ConferenceSelect'] = addConferenceSelectWidget
    Schema.widget_constructors['ConferenceDateWidget'] = addConferenceDateWidget

    Schema.widget_types_by_metatype[ConferenceMultipleSelectWidget.meta_type] = 'ConferenceMultipleSelect'
    Schema.widget_types_by_metatype[ConferenceSelectWidget.meta_type] = 'ConferenceSelect'
    Schema.widget_types_by_metatype[ConferenceDateWidget.meta_type] = 'ConferenceDateWidget'