from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Products.NaayaCore.EmailTool.EmailPageTemplate import EmailPageTemplateFile
from Products.NaayaCore.NotificationTool import NotificationTool, utils as NotificationToolUtils

contact_template = PageTemplateFile('zpt/contact', globals())
NotificationTool.email_templates['contact_email'] = EmailPageTemplateFile('zpt/contact_email.zpt', globals())

def setContactSession(fullname, email, organisation, subject, message, SESSION):
    SESSION.set('fullname', fullname)
    SESSION.set('email', email)
    SESSION.set('organisation', organisation)
    SESSION.set('subject', subject)
    SESSION.set('message', message)

def sendEmail(context, addr_to, **kwargs):
    site = context.getSite()
    email_tool = site.getEmailTool()
    addr_from = email_tool.get_addr_from()

    template = site.portal_notification._get_template('contact_email')
    mail_data = template(**kwargs)
    NotificationToolUtils.send_notification(email_tool, addr_from, addr_to,
                                            mail_data['subject'], mail_data['body_text'])

def contact_view(context, REQUEST):
    """ """
    err = []

    REQUEST.SESSION.set('email_sent', False)
    site = context.getSite()
    if REQUEST.form.has_key('send'):
        fullname = REQUEST.form.get('fullname', '')
        if fullname.strip() == '':
            err.append('The full name is required')

        email = REQUEST.form.get('email', '')
        if email.strip() == '':
            err.append('The email is required')

        organisation = REQUEST.form.get('organisation', '')
        if organisation.strip() == '':
            err.append('The organisation is required')

        subject = REQUEST.form.get('subject', '')
        if subject.strip() == '':
            err.append('The subject is required')

        message = REQUEST.form.get('message', '')
        if message.strip() == '':
            err.append('The message is required')

        if err:
            site.setSessionErrorsTrans(err)
            setContactSession(fullname, email, organisation, subject, message, REQUEST.SESSION)
        else:
            kwargs = {'fullname': fullname, 
                      'email': email, 
                      'organisation': organisation, 
                      'subject': subject, 
                      'message': message}
            sendEmail(context, site.administrator_email, **kwargs)
            REQUEST.SESSION.set('email_sent', True)
            REQUEST.SESSION.set('body', "Your message was sent. We'll get back to you shortly")
    return contact_template.__of__(context)()
