""" User interface methods (views) regarding registration in Destinet """
from Products.NaayaBase.NyContentType import SchemaFormHelper
from naaya.content.contact.contact_item import _create_NyContact_object

from destinet.registration.core import (validate_widgets, prepare_error_response,
                                        handle_groups)
from destinet.registration.constants import (EW_REGISTER_FIELD_NAMES,
                                             WIDGET_NAMES)
from Products.NaayaCore.SchemaTool.widgets.geo import Geo
from Products.NaayaCore.GeoMapTool.managers import geocoding

def do_geocoding(portal_map, properties):
    geo = properties.get('geo_location', None)
    if geo:
        lat = geo.lat
        lon = geo.lon
        address = geo.address
        if lat is None and lon is None and address:
            coordinates = geocoding.geocode(portal_map, address)
            if coordinates != None:
                lat, lon = coordinates
                properties['geo_location'] = Geo(lat=lat, lon=lon,
                                                 address=address)
    return properties


def render_create_account_tpl(context, widgets, request_form=None, errors=None):
    """ """

def create_destinet_account_html(context, request):
    """ """
    ns = {'here': context}
    contact_schema = context.getSite().getSchemaTool()['NyContact']
    sh = SchemaFormHelper(contact_schema, context)
    widgets = []
    for wid in WIDGET_NAMES:
        widgets.append(sh._get_renderer(wid, contact_schema["%s-property" % wid], False))
    register_extra_schema = context.getSite().getSchemaTool()['registration']
    sh = SchemaFormHelper(register_extra_schema, context)
    groups_widget = sh._get_renderer('groups', register_extra_schema['groups-property'], False)
    ns = {'widgets': widgets,
          'here': context,
          'groups_widget': groups_widget}
    return context.getFormsTool().getContent(ns, 'site_createaccount')

def process_create_account(context, request):
    """ """
    referer = request.HTTP_REFERER
    site = context.getSite()
    schema = site.getSchemaTool()['NyContact']
    register_schema = context.getSite().getSchemaTool()['registration']
    form_data, form_errors = validate_widgets(schema, register_schema, request.form)
    if form_errors:
        prepare_error_response(context, schema, register_schema, form_errors, request.form)
        # we need to put ourselves the user specific values in form
        args_for_session = {}
        for key in EW_REGISTER_FIELD_NAMES:
            args_for_session[key] = request.form.get(key)
        args_for_session['name'] = request.form.get('username')
        site.setRequestRoleSession(**args_for_session)
        request.RESPONSE.redirect(referer)
    else:
        # OBS: email is already sent here:
        site.processRequestRoleForm(request)
        redirect = request.RESPONSE.headers.get('location')
        if redirect != referer:
            # redirects to referer only when something is wrong in register form
            where = site['who-who']['destinet-users']
            username = request.form['username']
            contact_name = "%(firstname)s %(lastname)s" % request.form
            ob = _create_NyContact_object(where, username, username)
            ob.approveThis(1, username)
            ob.submitThis()
            ob.giveEditRights()
            # voodoo for setting ownership using AccessControl.Owned API
            new_user = site.acl_users.getUser(username).__of__(site.acl_users)
            ob.changeOwnership(new_user)

            site.admin_addroles([username], ['Contributor'], '', send_mail=True)
            handle_groups(ob, request.form, form_data)

            # hack to edit object without permissions (no auth)
            setattr(ob, 'checkPermissionEditObject', lambda: True)
            form_data = do_geocoding(site.portal_map, form_data)
            ob.manageProperties(title=contact_name,
                                firstname=request.form['firstname'],
                                lastname=request.form['lastname'],
                                organisation=request.form['organisation'],
                                approved=True,
                                description=request.form['comments'],
                                **form_data)
            delattr(ob, 'checkPermissionEditObject')
        else:
            # also call this to prefill values in form for contact
            prepare_error_response(context, schema, register_schema, form_errors, request.form)
            # ugly hack as a conseq of renaming Comments field
            if isinstance(request.SESSION.get('site_errors'), (tuple, list)):
                if 'Required field: Comments' in request.SESSION['site_errors']:
                    request.SESSION['site_errors'].remove('Required field: Comments')
                    request.SESSION['site_errors'].append('Required field: About Me')
