from Products.naayaUpdater.updates import UpdateScript

users = [('tsegura', ''),
 ('meta', ''),
 ('absolutely', ''),
 ('mehmetb', ''),
 ('pauchant', ''),
 ('naturesbestsweden', ''),
 ('herbert', u'European Ecotourism Network, '),
 ('multi', u'European Ecotourism Network'),
 ('josepcapella_dcb', ''),
 ('alpine.pearls.eva', ''),
 ('nayimba', u'European Ecotourism Network'),
 ('ppappas', ''),
 ('fttsa', u'European Ecotourism Network'),
 ('diegonunez', u'European Ecotourism Network, '),
 ('ruralaroma', u'European Ecotourism Network'),
 ('meozzi', ''),
 ('nekatur',
  u'agriculture, bed & breakfast, tourist destinations, tourist expectations, travel'),
 ('simonap', ''),
 ('elftours', u'European Ecotourism Network'),
 ('vilapark', ''),
 ('agrotravel2009',
  u'travel, trip, turismo, turismo responsable, turismo sostenible, viaje, viajes, vouyage'),
 ('scoco', ''),
 ('ullakask', u'European Ecotourism Network'),
 ('senka', u'European Ecotourism Network'),
 ('davorin', u'European Ecotourism Network'),
 ('victorm', u'UNESCO OLYMPIC YOUTH PEACE AMBASSADOR, '),
 ('shayonaholidays', u'European Ecotourism Network'),
 ('vschmidt', ''),
 ('aleksandra', ''),
 ('carlagcampos', u'European Ecotourism Network'),
 ('mani-sonnenlink', u'European Ecotourism Network'),
 ('chitkala', u'European Ecotourism Network'),
 ('uhpa', u'European Ecotourism Network, '),
 ('marokazepi', ''),
 ('briankingong', u'European Ecotourism Network'),
 ('evelina', ''),
 ('vesper', u'European Ecotourism Network, EEN, ecotourism'),
 ('transfer4u.gr', u'European Ecotourism Network'),
 ('diego', u'European Ecotourism Network'),
 ('paulasilva', u'European Ecotourism Network'),
 ('lemat', ''),
 ('greensoul', u'European Ecotourism Network, '),
 ('jazhotels', ''),
 ('darcydornan', ''),
 ('withymac', u'European Ecotourism Network'),
 ('catarina', u'European Ecotourism Network'),
 ('ecolabelluxembourg', ''),
 ('mchiara', ''),
 ('andrestest', u'European Ecotourism Network'),
 ('jameslyons', u'European Ecotourism Network'),
 ('nellycb', u'European Ecotourism Network'),
 ('matthieu.defrance', ''),
 ('mariana', u'European Ecotourism Network'),
 ('mute', u'European Ecotourism Network, '),
 ('sustenmechanism68', ''),
 ('tinadebrun', u'European Ecotourism Network'),
 ('hannes', u'European Ecotourism Network'),
 ('helma', u'European Ecotourism Network'),
 ('cara', u'European Ecotourism Network'),
 ('myrtosgr', ''),
 ('eleonas', u'European Ecotourism Network'),
 ('eumelia', u'European Ecotourism Network'),
 ('joseguerreiro', u'European Ecotourism Network'),
 ('2407m', u'European Ecotourism Network'),
 ('ilgrandefaggio', u'European Ecotourism Network'),
 ('spiritofdiscovery', ''),
 ('cmarizal', ''),
 ('cpo', ''),
 ('fatmakay', u'European Ecotourism Network'),
 ('labrothea', ''),
 ('chantel', ''),
 ('cherryland', u'European Ecotourism Network'),
 ('madeirafaunaflora', ''),
 ('adrumm', ''),
 ('c.withyman', u'European Ecotourism Network, '),
 ('veronika', u'European Ecotourism Network'),
 ('foreasdak', ''),
 ('yasindogan', ''),
 ('annaslua', ''),
 ('mehmetkuzu', ''),
 ('oiti', u'European Ecotourism Network'),
 ('enastria', u'European Ecotourism Network'),
 ('crest', ''),
 ('ankh', u'European Ecotourism Network, '),
 ('elsaterminel', ''),
 ('herberteen3', u'European Ecotourism Network, '),
 ('noakes', 'European Ecotourism Network'),
 ('kalvist', 'European Ecotourism Network'),
 ('natkal86', ''),
 ('leasudakova', 'European Ecotourism Network'),
 ('christian', ''),
 ('knimao', ''),
 ('ktsagarakis', ''),
 ('gizem', u'European Ecotourism Network, '),
 ('elenag', ''),
 ('cpsolarenergy', ''),
 ('myregatt', 'European Ecotourism Network'),
 ('annalisa.surini', u'training, '),
 ('rubicon', ''),
 ('natila', ''),
 ('sokolarskicentar', 'European Ecotourism Network'),
 ('resultastan', 'European Ecotourism Network'),
 ('varelidis', 'European Ecotourism Network'),
 ('dogader', 'European Ecotourism Network'),
 ('stevenoakes1',
  u'Asia Pacific, sustainable tourism, international development, GSTC, Pacific Asia Tourism, '),
 ('tinahedi', 'European Ecotourism Network'),
 ('malulu', ''),
 ('denistolkach', ''),
 ('brisque', ''),
 ('drandle', ''),
 ('vvmz', 'European Ecotourism Network'),
 ('rblack', ''),
 ('jldavies', ''),
 ('victorianugent', 'European Ecotourism Network'),
 ('kbricker', ''),
 ('swissdaniel', 'European Ecotourism Network'),
 ('swedisheco', ''),
 ('froman', ''),
 ('uwe', ''),
 ('david_policarpo', ''),
 ('serbia', ''),
 ('konto', 'European Ecotourism Network'),
 ('brasil.denise', ''),
 ('ozan2102', ''),
 ('h.genc', ''),
 ('hagovsky', 'European Ecotourism Network'),
 ('angeliki.r', ''),
 ('silvacultura', 'European Ecotourism Network'),
 ('elina', ''),
 ('ukachel', 'European Ecotourism Network'),
 ('testeaudeweb2', ''),
 ('agrizelj', 'European Ecotourism Network'),
 ('mclancy', ''),
 ('lousander', ''),
 ('mihaelamarc', ''),
 ('greenhopping', ''),
 ('masticulture', 'European Ecotourism Network'),
 ('mehmetkaradere', 'European Ecotourism Network'),
 ('mdulupcu', 'European Ecotourism Network'),
 ('carolinepluvier', 'European Ecotourism Network'),
 ('alexgonzalez', ''),
 ('sfigueras', ''),
 ('samaria', ''),
 ('ricardosilva', ''),
 ('taliasalem', ''),
 ('catuche', ''),
 ('eco-initiativeua', ''),
 ('gendera', ''),
 ('matthstrier', ''),
 ('madeiraff', ''),
 ('anulagalewska', 'European Ecotourism Network'),
 ('shiferaw', ''),
 ('sergeykask', ''),
 ('dharnas', 'European Ecotourism Network'),
 ('aboutfrance', ''),
 ('emilieg', ''),
 ('canancan', ''),
 ('wmadkour', 'European Ecotourism Network'),
 ('aimarabr', ''),
 ('gunci05', 'European Ecotourism Network'),
 ('jo_koehler', ''),
 ('junibelaqua', ''),
 ('tracceverdi', ''),
 ('peter', ''),
 ('sachina', ''),
 ('jonday', ''),
 ('bogdan_papuc', ''),
 ('dani.blasco', ''),
 ('greentourismfinland', ''),
 ('merillecotours', 'European Ecotourism Network'),
 ('earth', ''),
 ('eleonashotel', 'European Ecotourism Network'),
 ('elenab', 'European Ecotourism Network'),
 ('europarques', ''),
 ('villapinia', 'European Ecotourism Network'),
 ('hildes', ''),
 ('nikkirose', u'European Ecotourism Network, '),
 ('carpatbike', 'European Ecotourism Network'),
 ('kalouts', ''),
 ('cpfernbus', ''),
 ('laefa', ''),
 ('dimitry', ''),
 ('suderbyn', ''),
 ('laurinda', ''),
 ('federpaolo', ''),
 ('foreaskv', 'European Ecotourism Network'),
 ('associazione', 'European Ecotourism Network'),
 ('victoria', 'European Ecotourism Network'),
 ('d.reiser', ''),
 ('ruben', ''),
 ('jasminev', ''),
 ('helene.rebuffat', ''),
 ('envctl', u'European Ecotourism Network, '),
 ('navarat', 'European Ecotourism Network'),
 ('georgejacobs', 'European Ecotourism Network'),
 ('perlaky', 'European Ecotourism Network'),
 ('moutita', ''),
 ('peruvianmountains', ''),
 ('danubetourismclusteristar21', ''),
 ('barbaralands', ''),
 ('minzhanglucy', 'European Ecotourism Network'),
 ('caro', ''),
 ('mustafamustermann', ''),
 ('margaretbavaria', ''),
 ('alternativtour', ''),
 ('wrizi', ''),
 ('zidek', ''),
 ('alibaba210', ''),
 ('dweiss', ''),
 ('stefan', ''),
 ('serto', ''),
 ('greenpeople', ''),
 ('choosiewon', ''),
 ('www.zelenaneretva.ba', ''),
 ('originiverzi', 'European Ecotourism Network'),
 ('iberaves', ''),
 ('marlon', ''),
 ('victorn', 'European Ecotourism Network'),
 ('carla', ''),
 ('srilankaecotourismfoundation', ''),
 ('stefanie', ''),
 ('sereni', ''),
 ('dossier', 'European Ecotourism Network'),
 ('weissanne', ''),
 ('elena', 'European Ecotourism Network'),
 ('baiku', 'European Ecotourism Network'),
 ('lsantos', ''),
 ('ceo_gstc', ''),
 ('agreekadventure', 'European Ecotourism Network'),
 ('renatour', ''),
 ('mdumbi', ''),
 ('marcvanloo', 'European Ecotourism Network'),
 ('sustainablecaribbean', ''),
 ('nahar', 'European Ecotourism Network'),
 ('kjh', 'European Ecotourism Network'),
 ('ecarceller', ''),
 ('m.wientjens', u'European Ecotourism Network, '),
 ('fserra', ''),
 ('hiresicily', ''),
 ('nahar-1', 'European Ecotourism Network'),
 ('suzanne', 'European Ecotourism Network'),
 ('egypttravelcc', 'European Ecotourism Network'),
 ('kumuds', u'Sustainable Tourism, '),
 ('sleepwell', 'European Ecotourism Network'),
 ('danigolu', ''),
 ('kutchadventures', 'European Ecotourism Network'),
 ('zinas', u'European Ecotourism Network, '),
 ('kbaracsi', u'European Ecotourism Network, '),
 ('hanna', ''),
 ('dorothy333', ''),
 ('marialemos', ''),
 ('marosini_123', 'European Ecotourism Network'),
 ('fmontecito', u'European Ecotourism Network, '),
 ('dane1', ''),
 ('cloe2050', ''),
 ('clo721', ''),
 ('rastokirn', '')]

users = dict(users)

def fix_title(obj):
    """ Some titles have been set as bytestreams, we need unicode
    """
    for lang in obj._local_properties['title']:
        v = obj.getLocalAttribute('title', lang)
        try:
            unicode(v)
        except UnicodeDecodeError:
            v = v.decode('utf-8')
            obj.set_localpropvalue('title', lang, v)


class FixKeywordsForDestinetUsers(UpdateScript):
    """ Migration: fix keyword for users
    """
    title = 'Destinet: fix keywords for all Naaya Contacts'
    creation_date = 'Ian 10, 2013'
    authors = ['Tiberiu Ichim']
    description = ("Fix the keywords for users after it was lost")

    def _update(self, portal):
        context = portal.restrictedTraverse('who-who/destinet-users')

        for obj in context.objectValues("Naaya Contact"):
            fix_title(obj)

            obj._local_properties['keywords'] = {}
            v = users.get(obj.id, '')

            if not "Destinet User" in v:
                if v.strip():
                    v += ", Destinet User"
                else:
                    v = "Destinet User"

            obj.set_localpropvalue('keywords', 'en', v)

            self.log.info("Set the destinet user keyword for %s",
                              obj.absolute_url())

            context.recatalogNyObject(obj)

        return True
