## Script (Python) "EnvelopeArt8CoverLetter"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Cover letter for WFD reporting (currently: Art. 13)
##
from DateTime import DateTime

l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<p>In support of WISE - The Water Information System For Europe</p>

<br />

<p>To Whom It May Concern</p>

<p>This confirmation letter shows the status of national data submissions to Reportnet based on the European Reporting Obligation</p>

<p><strong>%s</strong> (<a href="%s">%s</a>)</p>

<p>The letter is automatically generated when the authorised national data reporter has released the respective reporting information inside the Central Data Repository (CDR).</p>

<p>The following delivery has been submitted for <strong>%s</strong> and was released on <strong>%s</strong>.</p>

<table>
	<tr>
		<th>Envelope:</th>
		<td>%s</td>
	</tr>
	<tr>
		<th>Location:</th>
		<td><a href="%s">%s</a></td>
	</tr>
</table>

<p>List of files:</p>

<ol>""" % (context.getMySelf().dataflow_lookup(context.getMySelf().dataflow_uris[0])['TITLE'], context.getMySelf().dataflow_uris[0], context.getMySelf().dataflow_uris[0], context.getMySelf().getCountryName(), DateTime().strftime('%d %B %Y'), context.getMySelf().title_or_id(), context.getMySelf().absolute_url(), context.getMySelf().absolute_url())


documents_list = context.getMySelf().objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s</li>' % (f.title_or_id())
    if f.meta_type == 'Report Document':
        zip_files = context.getMySelf().getZipInfo(f)
        if zip_files:
            l_ret += '<div class="zip_content">'
            l_ret += '<em>files contained inside the ' + f.title_or_id() + ' archive:</em>'
            l_ret += '<ul>'
            for file in zip_files:
                l_ret += '<li>%s</li>' % file
            l_ret += '</ul>'
            l_ret += '</div>'
l_ret += """

</ol>

<p>The above-mentioned files were submitted by: <em>%s</em> (user name: <em>%s</em>)</p>

<p>This confirmation letter is electronically generated by the Reportnet system and therefore not signed.</p>

<p>According to the WISE Reporting Arrangements agreed at the WFD Regulatory Committee in March 2007, this cover letter is generated to be printed and sent officially to the European Commission as proof of reporting delivery.</p>

""" % (context.getMySelf().getLDAPUserCanonicalName(context.getMySelf().getLDAPUser(context.getMySelf().getPreviousActor(str(int(workitem_id) - 2)))),context.getMySelf().getPreviousActor(str(int(workitem_id) - 2)))

context.getMySelf().manage_addFeedback(title="Confirmation of receipt", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.getMySelf().completeWorkitem(workitem_id)
