## Script (Python) "EnvelopeVOCCoverLetter"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Cover letter for the VOC directive
##
from DateTime import DateTime

l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<p>
Concerning: Council Directive 1999/13/EC of 11 March 1999 on the limitation of emissions of volatile organic compounds due to the use of organic solvents in certain activities and installations
</p>

<br />
<p>
To Whom It May Concern:
</p>
<p>
This confirmation letter shows the status of national data submissions to Reportnet based on the European Reporting Obligation </p>

<p>
Reports on the implementation of Directive 1999/13/EC during the period 2005-2007.
(<a href="%s">%s</a>)
</p>

<p>
The letter is automatically generated when the authorised national data reporter has released the respective 
reporting information inside the Central Data Repository (CDR).
</p>
<p>
The following files have been submitted for country %s into the envelope %s (<a href="%s">%s</a>) and
 are made publicly available on %s.
</p>

<p>
List of files:
</p>

<ol>""" % (context.getMySelf().dataflow_uris[0], context.getMySelf().dataflow_uris[0], context.getMySelf().getCountryName(), context.getMySelf().title_or_id(), context.getMySelf().absolute_url(), context.getMySelf().absolute_url(), DateTime().strftime('%d %B %Y'))

documents_list = context.getMySelf().objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s (<a href="%s">%s</a>)</li>' % (f.title_or_id(), f.absolute_url(), f.absolute_url())
    if f.meta_type == 'Report Document':
        zip_files = context.getMySelf().getZipInfo(f)
        if zip_files:
            l_ret += '<div class="zip_content">'
            l_ret += '<em>files contained inside the ' + f.title_or_id() + ' archive:</em>'
            l_ret += '<ul>'
            for file in zip_files:
                l_ret += '<li>%s</li>' % file
            l_ret += '</ul>'
            l_ret += '</div>'
l_ret += """
</ol>

<p>
The above-mentioned files were submitted by: <em>%s</em>
</p>

<p><em>
This confirmation letter is electronically generated by the Reportnet system and therefore not signed. 
</em></p>
""" % context.getMySelf().getLDAPUserCanonicalName(context.getMySelf().getLDAPUser(context.getMySelf().getPreviousActor(str(int(workitem_id) - 2))))

context.getMySelf().manage_delObjects(context.getMySelf().objectIds('Report Feedback'))
context.getMySelf().manage_addFeedback(title="Cover letter", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.getMySelf().completeWorkitem(workitem_id)
