## Script (Python) "EnvelopeGGCoverLetter"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Cover letter for the Greenhouse emissions
##
from DateTime import DateTime

l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<p><strong>To Whom It May Concern:</strong></p>

<p>
	This is a confirmation of receipt for national data submissions under the European Reporting Obligation
</p>

<p>
	Greenhouse gas emission inventories (Greenhouse gas monitoring mechanism (Council Decision 280/2004/EC) (<a href="http://rod.eionet.europa.eu/obligations/384">http://rod.eionet.europa.eu/obligations/384</a>)
</p>

<p>
	The following delivery has been submitted for %s to the Reportnet Central Data Repository (CDR) and was finalized on %s.
</p>

<table>
	<tr>
		<th>Envelope:</th>
		<td>%s</td>
	</tr>
	<tr>
		<th>Location:</th>
		<td>%s</td>
	</tr>
</table>
<p>
List of files:
</p>

<ol>""" % (context.getMySelf().getCountryName(), DateTime().strftime('%d %B %Y'), context.getMySelf().title_or_id(), context.getMySelf().absolute_url())

documents_list = context.getMySelf().objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s (<a href="%s">%s</a>)</li>' % (f.title_or_id(), f.absolute_url(), f.absolute_url())
    if f.meta_type == 'Report Document':
        zip_files = context.getMySelf().getZipInfo(f)
        if zip_files:
            l_ret += '<div class="zip_content">'
            l_ret += '<em>files contained inside the ' + f.title_or_id() + ' archive:</em>'
            l_ret += '<ul>'
            for file in zip_files:
                l_ret += '<li>%s</li>' % file
            l_ret += '</ul>'
            l_ret += '</div>'
l_ret += """
</ol>

<p>
The above-mentioned files were submitted by user: <em>%s</em>
</p>

<p><em>
This confirmation letter is electronically generated by the Reportnet system and therefore not signed. 
</em></p>

<p>
	Please note: Member States are requested to notify the European Commission 
	(DG Clima - Monitoring, Reporting and Verification unit) of all GHG data submissions uploaded to CDR:
	<a href="mailto:erasmia.kitou@ec.europa.eu">erasmia.kitou@ec.europa.eu</a>
</p>
""" % (context.getMySelf().getLDAPUserCanonicalName(context.getMySelf().getLDAPUser(context.getMySelf().getPreviousActor(str(int(workitem_id) - 2)))))

#context.getMySelf().manage_delObjects(context.getMySelf().objectIds('Report Feedback'))
context.getMySelf().manage_addFeedback(title="Receipt of delivery for the Greenhouse gas inventories", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.getMySelf().completeWorkitem(workitem_id)
