## Script (Python) "EnvelopeNECCoverLetter"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Cover letter for the NECdirective
##
from DateTime import DateTime

for x in context.getMySelf().objectValues('Workitem'):
 if x.activity_id == 'Draft':
  u = x.actor


l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<p><strong>To Whom It May Concern:</strong></p>

<p>
	This is a confirmation of receipt for national data submissions under the European Reporting Obligation
</p>

<p>
	National inventories and emission projections (<a href="http://rod.eionet.europa.eu/obligations/141">National Emission Ceilings</a> Directive 2001/81/EC) [Article 8 (1)]
</p>

<p>
	The following delivery has been submitted for %s to the Reportnet Central Data Repository (CDR) and was finalized on %s.
</p>

<table>
	<tr>
		<th>Envelope:</th>
		<td>%s</td>
	</tr>
	<tr>
		<th>Location:</th>
		<td>%s</td>
	</tr>
</table>
<p>
List of files:
</p>

<ol>""" % (context.getMySelf().getCountryName(), DateTime().strftime('%d %B %Y'), context.getMySelf().title_or_id(), context.getMySelf().absolute_url())

documents_list = context.getMySelf().objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s (<a href="%s">%s</a>)</li>' % (f.title_or_id(), f.absolute_url(), f.absolute_url())

l_ret += """
</ol>

<p>
The above-mentioned files were submitted by user: <em>%s</em>
</p>

<p><em>
This confirmation letter is electronically generated by the Reportnet system and therefore not signed. 
</em></p>

<p>
	Please note: Member States are requested to notify the Commission of all NEC data submissions uploaded to CDR: <a href="mailto:ENV-NECD@ec.europa.eu">ENV-NECD@ec.europa.eu</a>
</p>
""" % (context.getMySelf().getLDAPUserCanonicalName(context.getMySelf().getLDAPUser(u)))

context.getMySelf().manage_delObjects(context.getMySelf().objectIds('Report Feedback'))
context.getMySelf().manage_addFeedback(title="Receipt of delivery for NEC Directive", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.getMySelf().completeWorkitem(workitem_id)
