## Script (Python) "EnvelopeAddReceiptConfirmation"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Add a generic confirmation of receipt
##
from DateTime import DateTime

list_of_obligations = []

for obl in context.getMySelf().dataflow_uris:
    list_of_obligations.append("""<strong>%s</strong> (<a href="%s">%s</a>)""" % (context.getMySelf().dataflow_lookup(obl)['TITLE'], obl.replace('eionet.eu.int','eionet.europa.eu'), obl.replace('eionet.eu.int','eionet.europa.eu')))

obligations_para = "<br/>\n".join(list_of_obligations)

l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<br />
<p><strong>To Whom It May Concern</strong></p>

<br />
<p>This is a confirmation of receipt for national data submissions under the European Reporting Obligation</p>

<p>%s</p>

<p>
The following delivery has been submitted for <strong>%s</strong> to the Reportnet Central Data Repository (CDR) and was made available on <strong>%s</strong>.
</p>

<table>
<tr><td>Envelope:</td><td>%s</td></tr>
<tr><td>Location:</td><td><a href="%s">%s</a></td></tr>
</table>

<p>List of files:</p>

<ol>""" % (obligations_para, context.getMySelf().getCountryName(), DateTime().strftime('%d %B %Y'), context.getMySelf().title_or_id(), context.getMySelf().absolute_url(), context.getMySelf().absolute_url())

documents_list = context.getMySelf().objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s</li>' % (f.id)
    if f.meta_type == 'Report Document':
        zip_files = context.getMySelf().getZipInfo(f)
        if zip_files:
            l_ret += '<div class="zip_content">'
            l_ret += '<em>files contained inside the ' + f.title_or_id() + ' archive:</em>'
            l_ret += '<ul>'
            for file in zip_files:
                l_ret += '<li>%s</li>' % file
            l_ret += '</ul>'
            l_ret += '</div>'
l_ret += """
</ol>

<p>
The above-mentioned files were submitted by user: %s
</p>

<p><em>
This confirmation is electronically generated by the Reportnet system and therefore not signed.
</em></p>
""" % context.getMySelf().getPreviousActor(str(int(workitem_id) - 2))

context.getMySelf().manage_addFeedback(title="Confirmation of receipt", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.getMySelf().completeWorkitem(workitem_id)
