## Script (Python) "AddGenericCoverLetter"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=
##title=
##
from DateTime import DateTime

dfs = ''
for x in context.dataflow_uris:
 d_url = context.dataflow_lookup(x)['details_url']
 dfs += '<strong>%s</strong> (<a href="%s">%s</a>)<br />' % (context.dataflow_lookup(x)['TITLE'], d_url, d_url)

for x in context.objectValues('Workitem'):
 if x.activity_id == 'Draft':
  u = x.actor
l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>
<br /><br />
<p><strong>To Whom It May Concern:</strong></p>

<p>
	This is a confirmation of receipt for national data submissions under the European Reporting Obligation
</p>

<p>
	%s
</p>

<p>
	The following delivery has been submitted for <strong>%s</strong> to the Reportnet Central Data Repository (CDR) and was finalized on <strong>%s</strong>.
</p>

<table>
	<tr>
		<th>Envelope:</th>
		<td>%s</td>
	</tr>
	<tr>
		<th>Location:</th>
		<td>%s</td>
	</tr>
</table>
<p>
List of files:
</p>

<ol>""" % (dfs, context.getCountryName(), context.reportingdate.strftime('%d %B %Y'), context.title_or_id(), context.absolute_url())

documents_list = context.objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s (<a href="%s">%s</a>)</li>' % (f.title_or_id(), f.absolute_url(), f.absolute_url())

l_ret += """
</ol>

<p>
The above-mentioned files were submitted by user: <em>%s</em>
</p>

<p><em>
This confirmation letter is electronically generated by the Reportnet system and therefore not signed. 
</em></p>

""" % (context.getLDAPUserCanonicalName(context.getLDAPUser(u)))

context.manage_delObjects(context.objectIds('Report Feedback'))
context.manage_addFeedback(title="Confirmation of receipt", feedbacktext=l_ret, automatic=1, content_type='text/html')
