## Script (Python) "xmlrpc_search_shapefile"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=country=None,RA_ID=None
##title=Find shapefiles (used by Hermann for WFD reporting)
##
from Products.PythonScripts.standard import html_quote

def print_as_elm(mydict):
    attrs=[]
    for elm,value in mydict.items():
        attrs.append('%s="%s"' % (elm,html_quote(str(value))))
    return "  <file %s/>" % " ".join(attrs)

reslist = []

if RA_ID is None:
   RA_ID = 521

search_args = {
   'meta_type':'Report Document',
   'dataflow_uris':'http://rod.eionet.eu.int/obligations/' + str(RA_ID)
}

if country is not None:
    if len(country) == 2:
        search_args['country'] = context.localities_iso_dict(string.upper(country))['uri']

for item in container.Catalog(search_args):
    obj = item.getObject()
    
    if (string.upper(obj.id)[-3:] == 'DBF' or obj.xml_schema_location[:50] == 'http://water.eionet.europa.eu/schemas/dir200060ec/'):
        res = { 'url': obj.absolute_url(0),
            'id': obj.id,
            'title': obj.title,
            'country_code': obj.getCountryCode(),
            'locality': obj.locality,
            'schema': obj.xml_schema_location,
            'isreleased': obj.released,
            'reportingdate': obj.reportingdate.HTML4(),
            'uploaded': obj.upload_time().HTML4()
        }

        reslist.append(res)

req = context.REQUEST

if req['CONTENT_TYPE'] == 'text/xml' and req['REQUEST_METHOD'] == 'POST':
    return reslist
else:
    req.RESPONSE.setHeader('content-type','text/xml; charset=UTF-8')
    print "<results>"
    for d in reslist:
         print print_as_elm(d)
    print "</results>"
    return printed
