## Script (Python) "EnvelopeAddReceiptConfirmation"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=workitem_id, REQUEST
##title=Add a generic confirmation of receipt
##
from DateTime import DateTime

def getActorDraft():
    latestDraftWokitem = [wi for wi in context.getListOfWorkitems() if wi.activity_id == 'Draft'][-1]
    return latestDraftWokitem.actor

list_of_obligations = []

for obl in context.dataflow_uris:
    list_of_obligations.append("""<strong>%s</strong> (<a href="%s">%s</a>)""" % (context.dataflow_lookup(obl)['TITLE'], obl.replace('eionet.eu.int','eionet.europa.eu'), obl.replace('eionet.eu.int','eionet.europa.eu')))

obligations_para = "<br/>\n".join(list_of_obligations)

l_ret = """
<p>
European Environment Agency<br />
Kongens Nytorv 6<br />
DK 1050 Copenhagen K
</p>

<br />

<p><strong>To Whom It May Concern</strong></p>

<p>This is a confirmation of receipt for data submissions by an undertaking under the European Reporting Obligation:</p>

<p>%s</p>

<p>The following delivery has been submitted for <strong>%s</strong> and was finalized on <strong>%s</strong>.</p>

<table>
	<tr>
		<th>Envelope:</th>
		<td>%s</td>
	</tr>
	<tr>
		<th>Location:</th>
		<td><a href="%s">%s</a></td>
	</tr>
</table>

<p>List of files:</p>

<ul>""" % (obligations_para, context.aq_parent.title, DateTime().strftime('%d %B %Y'), context.title_or_id(), context.absolute_url(), context.absolute_url())


documents_list = context.objectValues(['Report Document', 'Report Hyperlink'])
documents_list.sort(key=lambda ob: ob.getId().lower())
for f in documents_list:
    l_ret += '<li>%s</li>' % (f.title_or_id())
    if f.meta_type == 'Report Document':
        zip_files = context.getZipInfo(f)
        if zip_files:
            l_ret += '<div class="zip_content">'
            l_ret += '<em>files contained inside the ' + f.title_or_id() + ' archive:</em>'
            l_ret += '<ul>'
            for file in zip_files:
                l_ret += '<li>%s</li>' % file
            l_ret += '</ul>'
            l_ret += '</div>'
l_ret += """

</ul>

<p>The above-mentioned files were submitted by: <em>%s</em> (user name: <em>%s</em>)</p>

<p><em>This confirmation letter is electronically generated by the Reportnet system and therefore not signed.</em></p>

""" % (context.getLDAPUserCanonicalName(context.getLDAPUser(getActorDraft())), getActorDraft())

context.manage_addFeedback(title="Confirmation of receipt", feedbacktext=l_ret, automatic=1, content_type='text/html')
context.completeWorkitem(workitem_id)
