


# Types of portlets:
PORTLETS_TYPES = {
    0: 'Static HTML',
    1: 'Links list',
    2: 'Remote channel',
    3: 'Local channel',
    4: 'Folder',
    5: 'Script channel',
    6: 'Remote channel facade',
    7: 'Remote channel aggregator',
    8: 'Remote channel with automatic translation',
    99: 'Other',
    100: 'Special'
}

#used for portlets that contains static HTML code
DEFAULT_PORTLET_HEADER = '''<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span i18n:translate="" tal:replace="template/title" /></tal:block>
<tal:block metal:fill-slot="portlet_content">'''
DEFAULT_PORTLET_FOOTER = '''</tal:block>
</tal:block>'''

#used to generate portlets for other types of objects: links list, rdf channels, folders etc.
SIMPLE_PORTLET_TEMPLATE = '''<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title">PORTLET_TITLE</tal:block>
<tal:block metal:fill-slot="portlet_content">PORTLET_CONTENT</tal:block>
</tal:block>'''

HTML_PORTLET_TEMPLATE = '''<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:replace="here/title" /></tal:block>
<tal:block metal:fill-slot="portlet_content"><span tal:replace="structure here/body" /></tal:block>
</tal:block>'''

LINKSLIST_PORTLET_TEMPLATE = '''<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:replace="python:here.getPortletsTool()['PORTLET_LINKSLIST_ID'].title_or_id()" i18n:translate=""/></tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
	<tal:block tal:repeat="item python:here.getPortletsTool()['PORTLET_LINKSLIST_ID'].get_links_list()">
		<li tal:condition="python:here.checkPermissionForLink(item.permission, here)">
			<a tal:attributes="href python:test(item.relative, '%s%s' % (here.getSitePath(), item.url), item.url); title item/description" i18n:attributes="title" i18n:translate="" tal:content="item/title" />
		</li>
	</tal:block>
	</ul>
</tal:block>
</tal:block>'''

REMOTECHANNEL_PORTLET_TEMPLATE = '''<tal:block define="channel python:here.getSyndicationTool()['PORTLET_REMOTECHANNEL_ID'];
		   title python:channel.title_or_id();
		   items python:channel.getChannelItems()"
		   condition="items">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:content="title" /></tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
		<li tal:repeat="item items">
			<a tal:attributes="href python:test(item.has_key('link'), item['link'], '')" tal:content="python:item['title']" />
		</li>
	</ul>
	<div style="text-align: right;">
	<a tal:attributes="href string:${here/absolute_url}/channel_details_html?id_channel=PORTLET_REMOTECHANNEL_ID">
		<span i18n:translate="">More...</span>
	</a>
	</div>
</tal:block>
</tal:block>
</tal:block>'''

REMOTECHANNEL_AUTOTRANSLATE_PORTLET_TEMPLATE = '''<tal:block define="channel python:here.getSyndicationTool()['PORTLET_REMOTECHANNEL_ID'];
		   title python:channel.title_or_id();
		   items python:channel.getChannelItems();
		   feed_lang python:test(channel.get_feed_lang(), channel.get_feed_lang(), channel.get_language_from_domain());
		   current_lang here/gl_get_selected_language"
		   condition="items">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:content="title" /></tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
		<li tal:repeat="item items">
			<a tal:attributes="href python:test(item.has_key('link'), item['link'], '')" tal:content="python:item['title']" />
		</li>
	</ul>
	<div style="text-align: right;">
	<a tal:attributes="href string:${here/absolute_url}/channel_details_html?id_channel=PORTLET_REMOTECHANNEL_ID">
		<span i18n:translate="">More...</span>
	</a>
	</div>
	<div class="automatic_translation" tal:condition="feed_lang">
		<div class="tip-msg">
			<strong>Information</strong>
			<p>
				Please note that these automatic translations are only meant to give the
				reader a general idea of what is contained in the news items (RSS feeds).
				Automatic translations differ in quality and the reader is advised to
				check the sources before quoting such translated texts or referring to
				them.
			</p>
		</div>
		<h4>Automatic translation by Google</h4>
		<ul>
			<li tal:repeat="item items">
				<a tal:attributes="href python:here.translate_url(item['link'], current_lang, feed_lang)"
						tal:content="python:here.translate(item['title'], current_lang, feed_lang)" />
			</li>
		</ul>
		<div style="text-align: right;">
			<a tal:define="url string:${here/absolute_url}/channel_details_html?id_channel=PORTLET_REMOTECHANNEL_ID"
					tal:attributes="href python:here.translate_url(url, current_lang, feed_lang)">
				<span i18n:translate="">More...</span>
			</a>
		</div>
	</div>
</tal:block>
</tal:block>
</tal:block>'''

LOCALCHANNEL_PORTLET_TEMPLATE = '''<tal:block tal:define="channel python:here.getSyndicationTool()['PORTLET_LOCALCHANNEL_ID']">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title">
	<span i18n:translate="" tal:content="channel/title_or_id" />
	<a tal:attributes="href channel/absolute_url">
		<img src="/misc_/NaayaCore/xml.png" alt="RSS Feed" title="RSS Feed" i18n:attributes="alt title" />
	</a>
	<a tal:attributes="href string:${channel/absolute_url}/?feed=atom">
		<img src="/misc_/NaayaCore/xml-blue.jpg" alt="Atom Feed" title="Atom Feed" i18n:attributes="alt title" />
	</a>
</tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
		<li tal:repeat="item channel/get_objects_for_rdf">
			<img tal:attributes="src item/icon; alt item/meta_type; title item/meta_type" style="vertical-align: -5px;" />
			<a tal:attributes="href item/absolute_url; title item/description" tal:content="item/title_or_id" />
		</li>
	</ul>
</tal:block>
</tal:block>
</tal:block>'''

FOLDER_PORTLET_TEMPLATE = '''<tal:block tal:define="folder python:here.getFolderByPath('PORTLET_FOLDER_PATH')">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><a tal:attributes="href folder/absolute_url" tal:content="folder/title_or_id" /></tal:block>
<tal:block metal:fill-slot="portlet_content" tal:content="structure folder/description"></tal:block>
</tal:block>
</tal:block>'''

SCRIPTCHANNEL_PORTLET_TEMPLATE = '''<tal:block tal:define="channel python:here.getSyndicationTool()['PORTLET_SCRIPTCHANNEL_ID']">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:replace="channel/title_or_id" /></tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
		<li tal:repeat="item channel/get_objects_for_rdf">
			<img tal:attributes="src item/icon; alt item/meta_type; title item/meta_type" style="vertical-align: -5px;" />
			<a tal:attributes="href item/absolute_url; title item/description" tal:content="item/title_or_id" />
			<span tal:replace="structure item/description" />
		</li>
	</ul>
	<a tal:attributes="href channel/absolute_url"><img src="misc_/NaayaCore/xml.png" alt="Syndication (XML)" i18n:attributes="alt" /></a>
</tal:block>
</tal:block>
</tal:block>'''

CHANNEL_AGGREGATOR_PORTLET_TEMPLATE = '''<tal:block define="title python:here.getSyndicationTool()['PORTLET_AGGREGATOR_ID'].title_or_id();
		   items python:here.getSyndicationTool()['PORTLET_AGGREGATOR_ID'].getRemoteChannelsItems()"
		   condition="not:python:items == [[], []]">
<tal:block metal:use-macro="python:here.getLayoutTool().getCurrentSkin().getTemplateById(portlet_macro).macros['portlet']">
<tal:block metal:fill-slot="portlet_title"><span tal:content="title" /></tal:block>
<tal:block metal:fill-slot="portlet_content">
	<ul>
		<tal:block tal:repeat="channel items">
			<li tal:repeat="item channel" ><a tal:attributes="href python:test(item.has_key('link'), item['link'], '')" tal:content="python:item['title']" /></li>
		</tal:block>
	</ul>
	<div style="text-align: right;">
	<a tal:attributes="href string:${here/absolute_url}/channel_details_html?id_channel=PORTLET_AGGREGATOR_ID">
		<span i18n:translate="">More...</span>
	</a>
	</div>
</tal:block>
</tal:block>
</tal:block>'''


PORTLETS_BODIES = {
    0: HTML_PORTLET_TEMPLATE,
    1: LINKSLIST_PORTLET_TEMPLATE,
    2: REMOTECHANNEL_PORTLET_TEMPLATE,
    3: LOCALCHANNEL_PORTLET_TEMPLATE,
    4: FOLDER_PORTLET_TEMPLATE,
    5: SCRIPTCHANNEL_PORTLET_TEMPLATE,
    6: REMOTECHANNEL_PORTLET_TEMPLATE,
    7: CHANNEL_AGGREGATOR_PORTLET_TEMPLATE,
    8: REMOTECHANNEL_AUTOTRANSLATE_PORTLET_TEMPLATE,
    99: SIMPLE_PORTLET_TEMPLATE,
    100: SIMPLE_PORTLET_TEMPLATE
}
