# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Owner of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Authors:
#
# Cornel Nitu, Finsiel Romania
# Dragos Chirila, Finsiel Romania

#Python imports

#Zope imports
import zLOG
from App.ImageFile import ImageFile
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass

#Product imports
from constants import *
from naaya.content.base.discover import get_pluggable_content
from naaya.content.base import discover
import NySite
import NyFolder
import NyFolderBase

def initialize(context):
    """ """
    #register classes
    context.registerClass(
        NySite.NySite,
        permission = PERMISSION_ADD_SITE,
        constructors = (
                NySite.manage_addNySite_html,
                NySite.manage_addNySite,
                ),
        icon = 'www/Site.gif',
        )
    context.registerClass(
        NyFolder.NyFolder,
        permission = PERMISSION_ADD_FOLDER,
        constructors = (
                NyFolder.manage_addNyFolder_html,
                NyFolder.folder_add_html,
                NyFolder.addNyFolder,
                ),
        icon = 'www/NyFolder.gif'
        )

    #initialize NaayaContent
    discover.initialize(context)

    from Products.NaayaCore.LayoutTool.DiskFile import allow_path
    allow_path('Products.Naaya:skel/layout/')

misc_ = {
    'NyFolder.gif':ImageFile('www/NyFolder.gif', globals()),
    'NyFolder_marked.gif':ImageFile('www/NyFolder_marked.gif', globals()),
    'Site.gif':ImageFile('www/Site.gif', globals()),
    'addcomment.gif': ImageFile('www/addcomment.gif', globals()),
    'ajax-loader.gif': ImageFile('www/ajax-loader.gif', globals()),
    'checked':ImageFile('www/checked.png', globals()),
    'checkin':ImageFile('www/checkin.gif', globals()),
    'checkout':ImageFile('www/checkout.gif', globals()),
    'comment.gif': ImageFile('www/comment.gif', globals()),
    'conflict_users.png': ImageFile('www/conflict_users.png', globals()),
    'copy.gif':ImageFile('www/copy.gif', globals()),
    'cut.gif':ImageFile('www/cut.gif', globals()),
    'delete.gif':ImageFile('www/delete.gif', globals()),
    'edit':ImageFile('www/edit.gif', globals()),
    'fullscreencollapse_icon.gif':ImageFile('www/fullscreencollapse_icon.gif', globals()),
    'fullscreenexpand_icon.gif':ImageFile('www/fullscreenexpand_icon.gif', globals()),
    'gadfly_container.gif': ImageFile('www/gadfly_container.gif', globals()),
    'info.png': ImageFile('www/info.png', globals()),
    'logintoadd.gif': ImageFile('www/logintoadd.gif', globals()),
    'minus.gif':ImageFile('www/minus.gif', globals()),
    'paste.gif':ImageFile('www/paste.gif', globals()),
    'plus.gif':ImageFile('www/plus.gif', globals()),
    'powered.gif':ImageFile('www/powered.gif', globals()),
    'printer.gif': ImageFile('www/printer.gif', globals()),
    'revoke_permission.png': ImageFile('www/revoke_permission.png', globals()),
    'select_all.gif':ImageFile('www/select_all.gif', globals()),
    'sort_asc.gif':ImageFile('www/sort_asc.gif', globals()),
    'sort_desc.gif':ImageFile('www/sort_desc.gif', globals()),
    'sort_not.gif':ImageFile('www/sort_not.gif', globals()),
    'spacer.gif':ImageFile('www/spacer.gif', globals()),
    'square.gif':ImageFile('www/square.gif', globals()),
    'star.png':ImageFile('www/star.png', globals()),
    'trash.gif': ImageFile('www/trash.gif', globals()),

    #drag & drop files
    'core.js': ImageFile('zpt/dragdrop/core.js.dtml', globals()),
    'events.js': ImageFile('zpt/dragdrop/events.js.dtml', globals()),
    'css.js': ImageFile('zpt/dragdrop/css.js.dtml', globals()),
    'coordinates.js': ImageFile('zpt/dragdrop/coordinates.js.dtml', globals()),
    'drag.js': ImageFile('zpt/dragdrop/drag.js.dtml', globals()),
    'dragsort.js': ImageFile('zpt/dragdrop/dragsort.js.dtml', globals()),
    'cookies.js': ImageFile('zpt/dragdrop/cookies.js.dtml', globals()),

    # documentation
    'admin_schema':ImageFile('www/documentation/admin_schema.png', globals()),
    'workflow':ImageFile('www/documentation/workflow.gif', globals()),
    'brief_layout':ImageFile('www/documentation/brief_layout.gif', globals()),
    'select_language_box':ImageFile('www/documentation/select_language_box.gif', globals()),
    'translate_edit':ImageFile('www/documentation/translate_edit.gif', globals()),
    'translate_add':ImageFile('www/documentation/translate_add.gif', globals()),
    'translate_tooltips':ImageFile('www/documentation/translate_tooltips.gif', globals()),
    'translate_demo':ImageFile('www/documentation/translate_demo.gif', globals()),
    'translate_messages':ImageFile('www/documentation/translate_messages.gif', globals()),

    #calendar
    'icon_calendar.gif':ImageFile('www/icon_calendar.gif', globals()),
    'nav-bg.gif':ImageFile('www/nav-bg.gif', globals()),
    'default-bg.gif':ImageFile('www/default-bg.gif', globals()),

    # Utilities JS
    'utils.js':ImageFile('www/js/utils.js', globals()),
    'mainsections.js':ImageFile('www/js/mainsections.js', globals()),
    'admin.js':ImageFile('www/js/admin.js', globals()),
    'json2.min.js':ImageFile('www/js/json2.min.js', globals()),

    # jQuery
    # Use jquery.js if version is of no importance
    'jquery.js':ImageFile('www/js/jquery-1.4.2.min.js', globals()),
    'jquery.min.js':ImageFile('www/js/jquery-1.4.2.min.js', globals()),
    'jquery-1.4.2.min.js':ImageFile('www/js/jquery-1.4.2.min.js', globals()),

    'jquery-1.3.2.min.js':ImageFile('www/js/jquery-1.3.2.min.js', globals()), # DEPRECATED

    # jQuery plugins
    'jquery-ui.js':ImageFile('www/js/jquery-ui-1.8.1.custom.min.js', globals()),
    'jquery.cookie.js':ImageFile('www/js/jquery.cookie.js', globals()),
    'jquery.bgiframe.min.js':ImageFile('www/js/jquery.bgiframe.min.js', globals()),
    'jquery.autocomplete.min.js':ImageFile('www/js/jquery.autocomplete.min.js', globals()),
    'jquery.tree.init.js':ImageFile('www/js/jquery.tree.init.js', globals()),
    'jquery.form.js':ImageFile('www/js/jquery.form.js', globals()),

    #CSS files
    'jquery-ui.css':ImageFile('www/js/css/jquery-ui.css', globals()),
    'jquery-ui-1.8.1.css':ImageFile('www/js/css/jquery-ui.css', globals()),
    'jquery.autocomplete.css':ImageFile('www/js/css/jquery.autocomplete.css', globals()),

    #Event index
    'yes.gif':ImageFile('www/yes.gif', globals()),
    'no.gif':ImageFile('www/no.gif', globals()),
}

def register_content(module, klass, module_methods, klass_methods, add_method):
    """ To be called from content type you want to register within Naaya Folder.

    module_methods = {METHOD_1: PERMISSION_1, METHOD_2: PERMISSION_2}
    klass_methods  = {METHOD_1: PERMISSION_1, METHOD_2: PERMISSION_2}
    add_method = ('METHOD_ADD_HTML', 'PERMISSION')

    See NaayaForum for an example.
    """
    security = ClassSecurityInfo()
    NyFolderBase.NyFolderBase.security = security

    # Register module methods
    for meth, permission in module_methods.items():
        meth_obj = getattr(module, meth, None)
        if not meth_obj:
            continue
        setattr(NyFolderBase.NyFolderBase, meth, meth_obj)
        if permission:
            NyFolderBase.NyFolderBase.security.declareProtected(permission, meth)

    # Register class methods
    for meth, permission in klass_methods.items():
        meth_obj = getattr(klass, meth, None)
        if not meth_obj:
            continue
        setattr(NyFolderBase.NyFolderBase, meth, meth_obj)
        if permission:
            NyFolderBase.NyFolderBase.security.declareProtected(permission, meth)

    klass_label = getattr(klass, 'meta_label', klass.meta_type)
    add_meth, add_perm = add_method
    NyFolderBase.NyFolderBase._dynamic_content_types[klass.meta_type] = (add_meth, klass_label, add_perm)
    zLOG.LOG(module.__name__, zLOG.INFO,
             'Dynamic module "%s" registered' % klass.__name__)

    InitializeClass(NyFolder.NyFolder)
