import os
import sys

from Globals import InitializeClass
from App.ImageFile import ImageFile
from AccessControl import ClassSecurityInfo
from AccessControl.Permissions import view_management_screens, view
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Acquisition import Implicit
from zope.interface import implements
from zope.event import notify
from naaya.content.base.events import NyContentObjectAddEvent
from naaya.content.base.events import NyContentObjectEditEvent

from Products.NaayaBase.NyContentType import NyContentType
from naaya.content.base.constants import *
from Products.NaayaBase.constants import *
from Products.NaayaBase.NyItem import NyItem
from Products.NaayaBase.NyAttributes import NyAttributes
from Products.NaayaBase.NyContentType import NyContentData
from Products.NaayaCore.managers.utils import slugify, uniqueId
from naaya.core import submitter
from naaya.core.zope2util import abort_transaction_keep_session

from interfaces import INyConferenceSpeaker
from permissions import PERMISSION_ADD_SPEAKER

DEFAULT_SCHEMA = {
    'title':            dict(sortorder=100, widget_type='String', label='Name', localized=True, required=True),
    'personaltitle':    dict(sortorder=110, widget_type='String', label='Personal title', localized=True),
    'jobtitle':         dict(sortorder=120, widget_type='String', label='Job title', localized=True),
    'department':       dict(sortorder=130, widget_type='String', label='Department', localized=True),
    'organisation':     dict(sortorder=140, widget_type='String', label='Organisation', localized=True),
    'email':            dict(sortorder=150, widget_type='String', label='Email'),
    'webpage':          dict(sortorder=160, widget_type='String', label='Webpage'),
    'biography':        dict(sortorder=170, widget_type='TextArea', label='Biography (HTML)', localized=True, tinymce=True),
}

# this dictionary is updated at the end of the module
config = {
        'product': 'NaayaContent',
        'module': 'speaker',
        'package_path': os.path.abspath(os.path.dirname(__file__)),
        'meta_type': 'Naaya Conference Speaker',
        'label': 'Conference Speaker',
        'permission': PERMISSION_ADD_SPEAKER,
        'forms': ['speaker_add', 'speaker_edit', 'speaker_index'],
        'add_form': 'speaker_add_html',
        'description': 'This is Naaya Conference Speaker type.',
        'default_schema': DEFAULT_SCHEMA,
        'schema_name': 'NyConferenceSpeaker',
        '_module': sys.modules[__name__],
        'additional_style': None,
        'icon': os.path.join(os.path.dirname(__file__), 'www', 'speaker.png'),
        '_misc': {
                'speaker.png': ImageFile('www/speaker.png', globals()),
            },
    }

def speaker_add_html(self, REQUEST=None, RESPONSE=None):
    """ """
    from Products.NaayaBase.NyContentType import get_schema_helper_for_metatype
    form_helper = get_schema_helper_for_metatype(self, config['meta_type'])
    return self.getFormsTool().getContent({
            'here': self,
            'kind': config['meta_type'],
            'action': 'addNyConferenceSpeaker',
            'form_helper': form_helper,
            'submitter_info_html': submitter.info_html(self, REQUEST),
        },
        'speaker_add')

def _create_NyConferenceSpeaker_object(parent, id, contributor):
    id = uniqueId(slugify(id or 'speaker', removelist=[]),
                  lambda x: parent._getOb(x, None) is not None)
    ob = NyConferenceSpeaker(id, contributor)
    parent.gl_add_languages(ob)
    parent._setObject(id, ob)
    ob = parent._getOb(id)
    ob.after_setObject()
    return ob

def addNyConferenceSpeaker(self, id='', REQUEST=None, contributor=None, **kwargs):
    """
    Create an Naaya speaker type of object.
    """
    if REQUEST is not None:
        schema_raw_data = dict(REQUEST.form)
    else:
        schema_raw_data = kwargs
    _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))
    schema_raw_data.setdefault('personaltitle', '')
    schema_raw_data.setdefault('jobtitle', '')
    schema_raw_data.setdefault('department', '')
    schema_raw_data.setdefault('organisation', '')
    schema_raw_data.setdefault('email', '')
    schema_raw_data.setdefault('webpage', '')
    schema_raw_data.setdefault('biography', '')
    schema_raw_data.setdefault('picture', '')

    _picture = schema_raw_data.pop('picture', '')

    id = uniqueId(slugify(id or schema_raw_data.get('title', '') or 'speaker',
                          removelist=[]),
                  lambda x: self._getOb(x, None) is not None)
    if contributor is None: contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()

    ob = _create_NyConferenceSpeaker_object(self, id, contributor)

    form_errors = ob.process_submitted_form(schema_raw_data, _lang)

    if REQUEST is not None:
        submitter_errors = submitter.info_check(self, REQUEST, ob)
        form_errors.update(submitter_errors)

    if form_errors:
        if REQUEST is None:
            raise ValueError(form_errors.popitem()[1]) # pick a random error
        else:
            abort_transaction_keep_session(REQUEST)
            ob._prepare_error_response(REQUEST, form_errors, schema_raw_data)
            REQUEST.RESPONSE.redirect('%s/speaker_add_html' % self.absolute_url())
            return

    ob.setPicture(_picture)

    approved, approved_by = 1, self.REQUEST.AUTHENTICATED_USER.getUserName()
    ob.approveThis(approved, approved_by)
    ob.submitThis()

    self.recatalogNyObject(ob)
    notify(NyContentObjectAddEvent(ob, contributor, schema_raw_data))
    #log post date
    auth_tool = self.getAuthenticationTool()
    auth_tool.changeLastPost(contributor)
    #redirect if case
    if REQUEST is not None:
        l_referer = REQUEST['HTTP_REFERER'].split('/')[-1]
        if l_referer == 'speaker_add_html':
            self.setSession('referer', self.absolute_url())
            return ob.object_submitted_message(REQUEST)
            REQUEST.RESPONSE.redirect('%s/messages_html' % self.absolute_url())
        else: # undefined state (different referer, called in other context)
            return ob

    return ob.getId()

class speaker(Implicit, NyContentData):
    """ """
    picture = None

    def setPicture(self, picture):
        if picture != '':
            if hasattr(picture, 'filename'):
                if picture.filename != '':
                    content = picture.read()
                    if content != '':
                        self.picture = content
                        self._p_changed = 1
            else:
                self.picture = picture
                self._p_changed = 1

    def delPicture(self):
        self.picture = None
        self._p_changed = 1

class NyConferenceSpeaker(speaker, NyAttributes, NyItem, NyContentType):
    """ """

    implements(INyConferenceSpeaker)

    meta_type = config['meta_type']
    meta_label = config['label']

    def manage_options(self):
        """ """
        l_options = ()
        l_options += ({'label': 'View', 'action': 'index_html'},) + NyItem.manage_options
        return l_options

    security = ClassSecurityInfo()

    def __init__(self, id, contributor):
        """ """
        self.id = id
        speaker.__init__(self)
        NyItem.__dict__['__init__'](self)
        self.contributor = contributor

    def getPicture(self, REQUEST=None):
        """ """
        return self.picture

    def hasPicture(self, version=None):
        return self.picture is not None

    def schedule_test(self):
        """ """
        import schedule

        reload(schedule)
        return schedule.compute_schedule(self.getSite())

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'saveProperties')
    def saveProperties(self, REQUEST=None, **kwargs):
        """ """
        if not self.checkPermissionEditObject():
            raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG

        if self.hasVersion():
            obj = self.version
            if self.checkout_user != self.REQUEST.AUTHENTICATED_USER.getUserName():
                raise EXCEPTION_NOTAUTHORIZED, EXCEPTION_NOTAUTHORIZED_MSG
        else:
            obj = self

        if REQUEST is not None:
            schema_raw_data = dict(REQUEST.form)
        else:
            schema_raw_data = kwargs
        _lang = schema_raw_data.pop('_lang', schema_raw_data.pop('lang', None))
        _picture = schema_raw_data.pop('picture', '')
        _del_picture = schema_raw_data.pop('del_picture', '')

        form_errors = self.process_submitted_form(schema_raw_data, _lang)

        if not form_errors:
            if _del_picture != '': 
                self.delPicture()
            else: 
                self.setPicture(_picture)

            self._p_changed = 1
            self.recatalogNyObject(self)
            #log date
            contributor = self.REQUEST.AUTHENTICATED_USER.getUserName()
            auth_tool = self.getAuthenticationTool()
            auth_tool.changeLastPost(contributor)
            notify(NyContentObjectEditEvent(self, contributor))
            if REQUEST:
                self.setSessionInfoTrans(MESSAGE_SAVEDCHANGES, date=self.utGetTodayDate())
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
        else:
            if REQUEST is not None:
                self._prepare_error_response(REQUEST, form_errors, schema_raw_data)
                self.setSession('del_picture', _del_picture)
                REQUEST.RESPONSE.redirect('%s/edit_html?lang=%s' % (self.absolute_url(), _lang))
            else:
                raise ValueError(form_errors.popitem()[1]) # pick a random error

    security.declareProtected(view, 'index_html')
    def index_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'speaker_index')

    security.declareProtected(PERMISSION_EDIT_OBJECTS, 'edit_html')
    def edit_html(self, REQUEST=None, RESPONSE=None):
        """ """
        return self.getFormsTool().getContent({'here': self}, 'speaker_edit')

InitializeClass(NyConferenceSpeaker)

config.update({
    'constructors': (addNyConferenceSpeaker,),
    'folder_constructors': [
            ('speaker_add_html', speaker_add_html),
            ('addNyConferenceSpeaker', addNyConferenceSpeaker),
        ],
    'add_method': addNyConferenceSpeaker,
    '_class': NyConferenceSpeaker,
})

def get_config():
    return config
