# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Owner of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania and Eau de Web are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Authors:
#
# Cristian Ciupitu, Eau de Web
from Products.naayaUpdater.updates import nyUpdateLogger as logger
from Products.naayaUpdater.NaayaContentUpdater import NaayaContentUpdater
from Products.NaayaSurvey.SurveyAnswer import SurveyAnswer

class CustomContentUpdater(NaayaContentUpdater):
    """Update SurveyAnswers"""

    def __init__(self, id):
        NaayaContentUpdater.__init__(self, id)
        self.title = 'Update SurveyAnswers'
        self.description = 'Adds the modification_time attribute to SurveyAnswer'
        self.update_meta_type = SurveyAnswer.meta_type

    def _verify_doc(self, doc):
        if not hasattr(doc, 'modification_time'):
            return doc
        logger.debug('Skipping %s' % (doc.absolute_url(1), ))
        return None

    def _update(self):
        for answer in self._list_updates():
            answer.modification_time = answer.bobobase_modification_time()
            logger.debug('Updated %s' % (answer.absolute_url(1), ))

def register(uid):
    return CustomContentUpdater(uid)
